const createLink = (file, i, rand = null) => {
  if (typeof file === 'string') {
    return <link rel="stylesheet" href={`${file}?rand=${rand || Math.random()}`} key={i}/>;
  }
  if (typeof file === 'object') {
    return <link rel="stylesheet" {...file} key={i}/>;
  }
  return null;
};

export const createHeadSection = (styleUrls, baseUrl, buildVersion = null) => {
  const linkTags = styleUrls ? styleUrls.map((file, i) => createLink(file, i, buildVersion)) : [];
  return [
    <meta name="viewport" content="width=device-width, initial-scale=1" />,
    ...linkTags
  ];

}

