import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { KnobControlConfig, KnobControlProps } from './types';
export declare type ArrayTypeKnobValue = string[] | readonly string[];
export interface ArrayTypeKnob extends KnobControlConfig<ArrayTypeKnobValue> {
    separator: string;
}
interface ArrayTypeProps extends KnobControlProps<ArrayTypeKnobValue> {
    knob: ArrayTypeKnob;
}
export default class ArrayType extends Component<ArrayTypeProps> {
    static defaultProps: Partial<ArrayTypeProps>;
    static propTypes: {
        knob: PropTypes.Validator<ArrayTypeKnob>;
        onChange: PropTypes.Validator<(value: ArrayTypeKnobValue) => ArrayTypeKnobValue>;
    };
    static serialize: (value: ArrayTypeKnobValue) => ArrayTypeKnobValue;
    static deserialize: (value: string[]) => string[];
    shouldComponentUpdate(nextProps: Readonly<ArrayTypeProps>): boolean;
    handleChange: (e: React.ChangeEvent<HTMLTextAreaElement>) => void;
    render(): JSX.Element;
}
export {};
