import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { DocumentContext, DocumentInitialProps, DocumentProps } from '../next-server/lib/utils';
import { DocumentContext as DocumentComponentContext } from '../next-server/lib/document-context';
export { DocumentContext, DocumentInitialProps, DocumentProps };
export declare type OriginProps = {
    nonce?: string;
    crossOrigin?: string;
};
export declare function middleware({ req, res }: DocumentContext): Promise<void>;
/**
 * `Document` component handles the initial `document` markup and renders only on the server side.
 * Commonly used for implementing server side rendering for `css-in-js` libraries.
 */
export default class Document<P = {}> extends Component<DocumentProps & P> {
    /**
     * `getInitialProps` hook returns the context object with the addition of `renderPage`.
     * `renderPage` callback executes `React` rendering logic synchronously to support server-rendering wrappers
     */
    static getInitialProps({ renderPage, }: DocumentContext): Promise<DocumentInitialProps>;
    static renderDocument<P>(Document: new () => Document<P>, props: DocumentProps & P): React.ReactElement;
    render(): JSX.Element;
}
export declare class Html extends Component<React.DetailedHTMLProps<React.HtmlHTMLAttributes<HTMLHtmlElement>, HTMLHtmlElement>> {
    static contextType: React.Context<{
        readonly _documentProps: DocumentProps;
        readonly _devOnlyInvalidateCacheQueryString: string;
    }>;
    static propTypes: {
        children: PropTypes.Validator<string | number | boolean | {} | PropTypes.ReactElementLike | PropTypes.ReactNodeArray>;
    };
    context: React.ContextType<typeof DocumentComponentContext>;
    render(): JSX.Element;
}
export declare class Head extends Component<OriginProps & React.DetailedHTMLProps<React.HTMLAttributes<HTMLHeadElement>, HTMLHeadElement>> {
    static contextType: React.Context<{
        readonly _documentProps: DocumentProps;
        readonly _devOnlyInvalidateCacheQueryString: string;
    }>;
    static propTypes: {
        nonce: PropTypes.Requireable<string>;
        crossOrigin: PropTypes.Requireable<string>;
    };
    context: React.ContextType<typeof DocumentComponentContext>;
    getCssLinks(): JSX.Element[] | null;
    getPreloadDynamicChunks(): (JSX.Element | null)[];
    getPreloadMainLinks(): JSX.Element[] | null;
    render(): JSX.Element;
}
export declare class Main extends Component {
    static contextType: React.Context<{
        readonly _documentProps: DocumentProps;
        readonly _devOnlyInvalidateCacheQueryString: string;
    }>;
    context: React.ContextType<typeof DocumentComponentContext>;
    render(): JSX.Element | "__NEXT_AMP_RENDER_TARGET__";
}
export declare class NextScript extends Component<OriginProps> {
    static contextType: React.Context<{
        readonly _documentProps: DocumentProps;
        readonly _devOnlyInvalidateCacheQueryString: string;
    }>;
    static propTypes: {
        nonce: PropTypes.Requireable<string>;
        crossOrigin: PropTypes.Requireable<string>;
    };
    context: React.ContextType<typeof DocumentComponentContext>;
    static safariNomoduleFix: string;
    getDynamicChunks(): (JSX.Element | null)[];
    getScripts(): (JSX.Element | null)[] | null;
    static getInlineScriptSource(documentProps: DocumentProps): string;
    render(): JSX.Element | null;
}
