import './SignOut.scss'
import themeContext from '$ustoreinternal/services/themeContext'
import { t } from '$themelocalization'
import { UStoreProvider } from '@ustore/core'
import { storefrontCookies, CookiesManager } from '$ustoreinternal/services/cookies'

/**
 * This component represents the signout icon in the header
 * When clicking - the store redirects to the login page
 *
 * @param {object} currentUser - the current user connected to the store
 */
const SignOut = (props) => {
  if (!props.currentUser) {
    return null
  }

  const { currentUser: { FirstName } } = props

  const { showThemeAsDraft, securityToken, storeID, classicUrl, languageCode, logoutUrl } = themeContext.get()
  const showRibbon = UStoreProvider.state.customState.get('showCookieRibbon')
  const deleteCookies = () => [storefrontCookies.token, storefrontCookies.storeID, storefrontCookies.language].forEach(cn => CookiesManager.deleteCookie(cn))

  const isDraft = showThemeAsDraft && showThemeAsDraft.toLowerCase() === 'true'

  const storeType = UStoreProvider && UStoreProvider.state && UStoreProvider.state.get().currentStore && UStoreProvider.state.get().currentStore.StoreType

  let sLogoutUrl = `${classicUrl}/logout.aspx?SecurityToken=${securityToken}&StoreGuid=${storeID}&NgLanguageCode=${languageCode}&ShowRibbon=${showRibbon}&forceLogin=true${isDraft ? '&showThemeAsDraft=true' : ''}`

  if (storeType === 3 && logoutUrl) sLogoutUrl = decodeURIComponent(logoutUrl)

  return (
    <div className="signout">
      <div className="info">
        <div className="title">{t('Profile.My_Account')}</div>
        <div className="greeting truncate">{t('SignOut.Hello_Message', { FirstName })}</div>
      </div>
      <div className="btn-container d-flex align-items-center">
        <a onClick={deleteCookies} href={sLogoutUrl} className="button-secondary">{t('SignOut.SignOut')}</a>
      </div>
    </div>
  )
}
export default SignOut
