const path = require('path')
const MiniCssExtractPlugin = require('mini-css-extract-plugin')


module.exports = {
  mode: 'production',
  devtool: 'source-map',
  entry: './src/index.js',
  output: {
    path: `${path.resolve(__dirname, './lib')}`,
    filename: 'main.min.js',
    library: {
      name: '_ustore_core',
      type: 'umd'
    },
    assetModuleFilename: 'assets/[hash][ext][query]',
  },
  externals: {
    react: 'React',
    'react-dom': 'ReactDOM',
    'prop-types': 'PropTypes'
  },
  plugins: [new MiniCssExtractPlugin()],
  module: {
    rules: [
      {
        test: /\.js?$/,
        use: [
          {
            loader: "babel-loader",
          }
        ]
      },
    ]
  }
};

