import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { KnobControlConfig, KnobControlProps } from './types';
declare type DateTypeKnobValue = number;
export declare type DateTypeKnob = KnobControlConfig<DateTypeKnobValue>;
declare type DateTypeProps = KnobControlProps<DateTypeKnobValue>;
interface DateTypeState {
    valid: boolean | undefined;
}
export default class DateType extends Component<DateTypeProps, DateTypeState> {
    static defaultProps: DateTypeProps;
    static propTypes: {
        knob: PropTypes.Validator<KnobControlConfig<number>>;
        onChange: PropTypes.Validator<(value: number) => number>;
    };
    static serialize: (value: number) => number;
    static deserialize: (value: number) => number;
    static getDerivedStateFromProps(): {
        valid: boolean;
    };
    state: DateTypeState;
    dateInput: HTMLInputElement;
    timeInput: HTMLInputElement;
    componentDidUpdate(): void;
    onDateChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
    onTimeChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
    render(): JSX.Element | null;
}
export {};
