/*!
 *
 */
import _Object$assign from 'babel-runtime/core-js/object/assign';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _JSON$stringify from 'babel-runtime/core-js/json/stringify';
import _regeneratorRuntime from 'babel-runtime/regenerator';
import _asyncToGenerator from 'babel-runtime/helpers/asyncToGenerator';
import 'isomorphic-fetch';
import _typeof from 'babel-runtime/helpers/typeof';
import _Object$entries from 'babel-runtime/core-js/object/entries';
import deepcopy from 'deepcopy';
import { createStore, applyMiddleware } from 'redux';
import { composeWithDevTools } from 'redux-devtools-extension';
import thunkMiddleware from 'redux-thunk';
import _Object$values from 'babel-runtime/core-js/object/values';
import _Promise from 'babel-runtime/core-js/promise';

var Context = function () {
  function Context() {
    _classCallCheck(this, Context);

    this.context = {};
  }

  Context.prototype.set = function set$$1(obj) {
    this.context = _Object$assign({}, this.context, obj);
  };

  Context.prototype.getValue = function getValue(key) {
    return this.context[key];
  };

  Context.prototype.setValue = function setValue(key, value) {
    this.context[key] = value;
  };

  Context.prototype.clear = function clear() {
    this.context = {};
  };

  Context.prototype.get = function get$$1() {
    return this.context;
  };

  return Context;
}();

var contextService = new Context();

var Logger = function () {
  function Logger() {
    _classCallCheck(this, Logger);
  }

  Logger.prototype.log = function log() {
    var _logger;

    (_logger = this.logger).log.apply(_logger, arguments);
  };

  Logger.prototype.warn = function warn() {
    var _logger2;

    (_logger2 = this.logger).warn.apply(_logger2, arguments);
  };

  Logger.prototype.info = function info() {
    var _logger3;

    (_logger3 = this.logger).info.apply(_logger3, arguments);
  };

  Logger.prototype.error = function error() {
    var _logger4;

    (_logger4 = this.logger).error.apply(_logger4, arguments);
  };

  _createClass(Logger, [{
    key: 'logger',
    get: function get$$1() {
      if (!this._logger) {
        this._logger = require('logdown')('ustore');
        this._logger.isEnabled = process.env.NODE_ENV !== 'production';
      }
      return this._logger;
    }
  }]);

  return Logger;
}();

var logger = new Logger();

var formatResponse = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(callOptions, response) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.prev = 0;

            if (!callOptions.json) {
              _context.next = 5;
              break;
            }

            _context.next = 4;
            return response.json();

          case 4:
            return _context.abrupt('return', _context.sent);

          case 5:
            _context.next = 7;
            return response.text();

          case 7:
            return _context.abrupt('return', _context.sent);

          case 10:
            _context.prev = 10;
            _context.t0 = _context['catch'](0);

            logger.error('Error on formatting response : ', callOptions, response);
            return _context.abrupt('return', response);

          case 14:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, this, [[0, 10]]);
  }));

  return function formatResponse(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

function createHeaders(options) {
  // get parameters from coreStateParams to init data in header
  var token = contextService.getValue('securityToken');
  var contentLanguage = contextService.getValue('languageCode');

  if (!options.static) {
    var headers = _Object$assign({}, {
      'Accept': 'application/json',
      'Content-Type': 'application/json',
      'Accept-Language': contentLanguage
    });

    if (options.auth) {
      _Object$assign(headers, { 'Authorization': 'uStore ' + token });
    }

    return headers;
  }

  return {};
}

var http = ['get', 'post', 'put', 'delete'].reduce(function (map, method) {
  map[method] = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(url, requestBody, options) {
      var callOptions, reqOptions, res, formattedResponse;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              callOptions = _Object$assign({
                auth: true,
                json: true,
                static: false
              }, options);
              reqOptions = {
                headers: createHeaders(callOptions),
                method: method,
                body: requestBody ? _JSON$stringify(requestBody) : undefined
              };
              _context2.next = 4;
              return fetch('' + url, reqOptions);

            case 4:
              res = _context2.sent;

              logger.info('Request to API : ', url, reqOptions);

              _context2.next = 8;
              return formatResponse(callOptions, res);

            case 8:
              formattedResponse = _context2.sent;

              logger.info('Response from API : ', _JSON$stringify(formattedResponse));

              if (res.ok) {
                _context2.next = 23;
                break;
              }

              if (!(formattedResponse.TypeName === 'OperationFailed')) {
                _context2.next = 13;
                break;
              }

              throw formattedResponse;

            case 13:
              _context2.prev = 13;

              logger.error('Error in request : ', url, reqOptions);

              if (formattedResponse.TypeName === 'AccessDenied') {
                contextService.getValue('onAccessDenied')();
              } else if (formattedResponse.TypeName === 'ResourceNotAvailable.Store') {
                contextService.getValue('onStoreNotAvailable')();
              } else contextService.getValue('onGeneralError')();
              throw formattedResponse;

            case 19:
              _context2.prev = 19;
              _context2.t0 = _context2['catch'](13);

              // logger.info('General Error')
              if (!_context2.t0 || !_context2.t0.TypeName) contextService.getValue('onGeneralError')();

              throw formattedResponse;

            case 23:
              return _context2.abrupt('return', formattedResponse);

            case 24:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this, [[13, 19]]);
    }));

    return function (_x3, _x4, _x5) {
      return _ref2.apply(this, arguments);
    };
  }();

  return map;
}, {});

var defaultState = {
  currentStore: null,
  currentUser: null,
  initState: true,
  customState: {},
  cultures: [],
  currentCulture: null,
  currencies: [],
  currentCurrency: null
};

var LOAD_CURRENT_STORE = 'LOAD_CURRENT_STORE';
var LOAD_CURRENT_USER = 'LOAD_CURRENT_USER';
var LOAD_USER_ORDERS_SUMMARY = 'LOAD_USER_ORDERS_SUMMARY';
var LOAD_PRODUCTS = 'LOAD_PRODUCTS';
var SET_CUSTOM_VAR = 'SET_CUSTOM_VAR';
var DELETE_CUSTOM_VAR = 'DELETE_CUSTOM_VAR';
var MERGE_CUSTOM_STATE = 'MERGE_CUSTOM_STATE';
var LOAD_CATEGORIES = 'LOAD_CATEGORIES';
var LOAD_CATEGORIES_TREE = 'LOAD_CATEGORIES_TREE';
var LOAD_SUB_CATEGORIES = 'LOAD_SUB_CATEGORIES';
var LOAD_CULTURES = 'LOAD_CULTURES';
var LOAD_CURRENT_CATEGORY = 'LOAD_CURRENT_CATEGORY';

var LOAD_CURRENCIES = 'LOAD_CURRENCIES';
var SET_CURRENT_CURRENCY = 'SET_CURRENT_CURRENCY';
var SET_CURRENT_CULTURE = 'SET_CURRENT_CULTURE';
var SET_CURRENT_CULTURE_BY_LANGUAGE = 'SET_CURRENT_CULTURE_BY_LANGUAGE';
var CLEAR_STATE = 'CLEAR_STATE';

var convertObjectToQueryString = function convertObjectToQueryString(obj) {
  return _Object$entries(obj).map(function (_ref) {
    var key = _ref[0],
        value = _ref[1];
    return key && value ? key + '=' + encodeURIComponent(value) : '';
  }).filter(function (s) {
    return !!s;
  }).join('&');
};

var merge = function merge(o1, o2) {
  var o = deepcopy(o1);
  for (var n in o2) {
    if (_typeof(o2[n]) !== 'object' || o2[n] === null) {
      o[n] = o2[n];
    } else if (Array.isArray(o2[n])) {
      o[n] = [].concat(o2[n]);
    } else {
      o[n] = o[n] ? merge(o[n], o2[n]) : merge({}, o2[n]);
    }
  }
  return o;
};

// REDUCERS
var reducer = (function () {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;
  var action = arguments[1];

  switch (action.type) {
    case '@@INIT_STATE':
      return _Object$assign({}, state, action.data, { initState: false });
    case LOAD_CURRENT_STORE:
      return _Object$assign({}, state, { currentStore: action.data });
    case LOAD_CURRENT_USER:
      return _Object$assign({}, state, { currentUser: action.data });
    case LOAD_USER_ORDERS_SUMMARY:
      return _Object$assign({}, state, { userOrdersSummary: action.data });
    case LOAD_CATEGORIES:
      return _Object$assign({}, state, { categories: action.data });
    case LOAD_CATEGORIES_TREE:
      var categoriesTree = action.data;
      var firstLevelCategories = categoriesTree.map(function (node) {
        return node.Category;
      });
      return _Object$assign({}, state, { categoriesTree: categoriesTree, categories: firstLevelCategories });
    case LOAD_SUB_CATEGORIES:
      return _Object$assign({}, state, { subCategories: action.data });
    case LOAD_CULTURES:
      return _Object$assign({}, state, { cultures: action.data });
    case LOAD_CURRENCIES:
      return _Object$assign({}, state, { currencies: action.data });
    case SET_CURRENT_CULTURE:
      return _Object$assign({}, state, { currentCulture: action.data });
    case SET_CURRENT_CULTURE_BY_LANGUAGE:
      var culture = action.data && state.cultures.length > 0 ? state.cultures.filter(function (c) {
        return c.LanguageCode === action.data;
      })[0] : null;
      return _Object$assign({}, state, { currentCulture: culture });
    case SET_CURRENT_CURRENCY:
      var currency = action.data ? action.data : state.currencies.length > 0 ? state.currencies.filter(function (c) {
        return c.ID === state.currentStore.PrimaryCurrencyID;
      })[0] : null;
      return _Object$assign({}, state, { currentCurrency: currency });
    case LOAD_CURRENT_CATEGORY:
      return _Object$assign({}, state, { currentCategory: action.data, subCategories: null });
    case LOAD_PRODUCTS:
      return _Object$assign({}, state, { products: action.data.products });
    case SET_CUSTOM_VAR:
      var mergedCustomState = _Object$assign(state.customState, action.data);
      return _Object$assign({}, state, { customState: mergedCustomState });
    case DELETE_CUSTOM_VAR:
      var customStateDup = _Object$assign({}, state.customState);
      delete customStateDup[action.data.name];
      return _Object$assign({}, state, { customState: customStateDup });
    case MERGE_CUSTOM_STATE:
      return _Object$assign({}, state, { customState: merge(state.customState, action.data) });
    case CLEAR_STATE:
      return _Object$assign({}, state, defaultState);
  }

  return state;
});

var initStore = function initStore() {
  var initialState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultState;

  // the following lines are not duplicate
  // the build will select the correct line according to the type of the build
  // ==== DO NOT DELETE ====
  return createStore(reducer, initialState, composeWithDevTools(applyMiddleware(thunkMiddleware)));
  return createStore(reducer, initialState, applyMiddleware(thunkMiddleware));
};

var ProviderState = function () {
  function ProviderState() {
    _classCallCheck(this, ProviderState);

    this.store = initStore();
  }

  ProviderState.prototype.get = function get$$1() {
    return this.store.getState();
  };

  ProviderState.prototype.set = function set$$1(state) {
    this.store.dispatch({ type: '@@INIT_STATE', data: state });
  };

  ProviderState.prototype.setInitState = function setInitState() {
    this.store.dispatch({ type: '@@INIT_STATE' });
  };

  ProviderState.prototype.setCustomState = function setCustomState(name, value) {
    var _data;

    this.store.dispatch({ type: SET_CUSTOM_VAR, data: (_data = {}, _data[name] = value, _data) });
  };

  ProviderState.prototype.setBulkCustomState = function setBulkCustomState(obj) {
    this.store.dispatch({ type: SET_CUSTOM_VAR, data: obj });
  };

  ProviderState.prototype.deleteCustomState = function deleteCustomState(name) {
    this.store.dispatch({ type: DELETE_CUSTOM_VAR, data: { name: name } });
  };

  ProviderState.prototype.mergeCustomState = function mergeCustomState(newState) {
    this.store.dispatch({ type: MERGE_CUSTOM_STATE, data: newState });
  };

  ProviderState.prototype.clear = function clear() {
    this.store.dispatch({ type: CLEAR_STATE, data: {} });
  };

  _createClass(ProviderState, [{
    key: 'dispatch',
    get: function get$$1() {
      return this.store.dispatch;
    }
  }, {
    key: 'subscribe',
    get: function get$$1() {
      return this.store.subscribe;
    }
  }]);

  return ProviderState;
}();

var providerState = new ProviderState();

var Config = function () {
  function Config() {
    _classCallCheck(this, Config);
  }

  Config.prototype.set = function set$$1(obj) {
    this.config = obj;
    this.configInit = true;
  };

  Config.prototype.getValue = function getValue(key) {
    return this.config[key];
  };

  Config.prototype.isInit = function isInit() {
    return this.configInit;
  };

  Config.prototype.get = function get$$1() {
    return this.config;
  };

  return Config;
}();

var config = new Config();

var _this = undefined;

var getTopCategories = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context.abrupt('return', _context.sent);

          case 4:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this);
  }));

  return function getTopCategories(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var getSubCategories = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID + '/categories' + (params.length ? '?' + params : ''));

          case 3:
            return _context2.abrupt('return', _context2.sent);

          case 4:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, _this);
  }));

  return function getSubCategories(_x3, _x4, _x5) {
    return _ref2.apply(this, arguments);
  };
}();

var getCategoryIDByFriendlyID = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/id?friendlyID=' + categoryFriendlyID);

          case 2:
            return _context3.abrupt('return', _context3.sent);

          case 3:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, _this);
  }));

  return function getCategoryIDByFriendlyID(_x6) {
    return _ref3.apply(this, arguments);
  };
}();

var getCategory = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(categoryID) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID);

          case 2:
            return _context4.abrupt('return', _context4.sent);

          case 3:
          case 'end':
            return _context4.stop();
        }
      }
    }, _callee4, _this);
  }));

  return function getCategory(_x7) {
    return _ref4.apply(this, arguments);
  };
}();

var getCategoryTree = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(depth) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/tree?depth=' + depth);

          case 2:
            return _context5.abrupt('return', _context5.sent);

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, _this);
  }));

  return function getCategoryTree(_x8) {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Represent the categories logic and API in the system
 */

var Categories = function () {
  function Categories() {
    _classCallCheck(this, Categories);
  }

  /**
   * Set **state.categoriesTree** with the categories tree.
   * Set **state.categories** with the first level categories group.
   * @param {number} [depth] - Indicates the maximum depth of the tree to return. By default (1), returns root categories only.
   * @returns {CategoryTreeModel} - The tree of categories
   */
  Categories.prototype.loadCategoriesTree = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var depth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

      var _ref2, Categories;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCategoryTree(depth);

            case 2:
              _ref2 = _context.sent;
              Categories = _ref2.Categories;

              providerState.dispatch({ type: LOAD_CATEGORIES_TREE, data: Categories });
              return _context.abrupt('return', Categories);

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCategoriesTree() {
      return _ref.apply(this, arguments);
    }

    return loadCategoriesTree;
  }();

  /**
   * Set **state.subCategories** with the sub-categories of the given category in the store, using paging.
   * Sub-categories without online product(s) on any level of their branch - are not included.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @param {number} [pageNumber] - The 1-based number of the page.
   * @param {number} [pageSize] - The amount of the categories in one page.
   * @returns Array of sub categories in a specific page
   */


  Categories.prototype.loadSubCategories = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryFriendlyID) {
      var pageNumber = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
      var pageSize = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

      var categoryID, _ref4, Categories;

      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context2.sent;
              _context2.next = 5;
              return getSubCategories(categoryID, pageNumber, pageSize);

            case 5:
              _ref4 = _context2.sent;
              Categories = _ref4.Categories;

              providerState.dispatch({ type: LOAD_SUB_CATEGORIES, data: Categories });
              return _context2.abrupt('return', Categories);

            case 9:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadSubCategories(_x4) {
      return _ref3.apply(this, arguments);
    }

    return loadSubCategories;
  }();

  /**
   * Set state.currentCategory with the requested category by friendlyID.
   * @param {string} categoryFriendlyID - the category friendly ID
   * @returns {CategoryModel} - A category model
   */


  Categories.prototype.loadCurrentCategory = function () {
    var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(categoryFriendlyID) {
      var categoryID, currentCategory;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCategoryIDByFriendlyID(categoryFriendlyID);

            case 2:
              categoryID = _context3.sent;
              _context3.next = 5;
              return getCategory(categoryID);

            case 5:
              currentCategory = _context3.sent;

              providerState.dispatch({ type: LOAD_CURRENT_CATEGORY, data: currentCategory });
              return _context3.abrupt('return', currentCategory);

            case 8:
            case 'end':
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadCurrentCategory(_x5) {
      return _ref5.apply(this, arguments);
    }

    return loadCurrentCategory;
  }();

  return Categories;
}();

var categories = new Categories();

/**
 * Represent the products logic and API in the system
 */
var Products = function Products() {
  _classCallCheck(this, Products);
};

var products = new Products();

var Binding = function () {
  function Binding() {
    var _this = this;

    _classCallCheck(this, Binding);

    this.webComponents = {};
    this.componentId = 1;
    this.state = providerState;

    // subscribe to store changes and set model attribute on all
    // connected components
    this.state.store.subscribe(function () {
      setTimeout(function () {
        var model = _JSON$stringify(_this.state.get());
        _Object$values(_this.webComponents).forEach(function (c) {
          return c.setAttribute('model', model);
        });
      }, 0);
    });
  }

  // register a new component set an binding id to allow removing the
  // component when unregistering
  // listening to the action event and dispatching it to redux store.


  Binding.prototype.register = function register(component) {
    var _this2 = this;

    var model = _JSON$stringify(this.state.get());
    component.ustoreBindingId = this.componentId;
    component.addEventListener('action', function (_ref) {
      var data = _ref.data;
      return _this2.state.dispatch(data);
    });
    this.webComponents[this.componentId] = component;
    component.setAttribute('model', model);
    this.componentId++;
  };

  Binding.prototype.unregister = function unregister(ustoreBindingId) {
    delete this.webComponents[ustoreBindingId];
  };

  return Binding;
}();

var bindingService = new Binding();

/**
 * Represents the culture logic in the system
 */

var Culture = function () {
  function Culture() {
    _classCallCheck(this, Culture);
  }

  /**
   * Set **state.currentCurrency** with the requested currency model
   * @param {CurrencyModel} currentCurrency - the requested currency to set as the current currency
   */
  Culture.prototype.setCurrentCurrency = function setCurrentCurrency(currentCurrency) {
    providerState.dispatch({ type: SET_CURRENT_CURRENCY, data: currentCurrency });
  };

  /**
   * Set **state.currentCurrency** according the the language code requested
   * @param {string} languageCode - the requested language code
   */


  Culture.prototype.setCurrentCultureByLanguage = function setCurrentCultureByLanguage(languageCode) {
    providerState.dispatch({ type: SET_CURRENT_CULTURE_BY_LANGUAGE, data: languageCode });
  };

  /**
   * Get the converted price according to the current currency in the state
   * @param {ProductPriceModel} priceModel - the price model to be converted
   * @returns {json} - price, tax and priceIncludingTax that are converted by the current currency
   */


  Culture.prototype.getConvertedPrices = function getConvertedPrices(priceModel) {
    var _providerState$get = providerState.get(),
        currentCurrency = _providerState$get.currentCurrency;

    return {
      price: priceModel.Price * currentCurrency.ConversionRate,
      tax: priceModel.Tax * currentCurrency.ConversionRate,
      priceIncludingTax: (priceModel.Price + priceModel.Tax) * currentCurrency.ConversionRate
    };
  };

  return Culture;
}();

var cultureService = new Culture();

var _this$1 = undefined;

var getCurrentStore = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store');

          case 2:
            return _context.abrupt('return', _context.sent);

          case 3:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this$1);
  }));

  return function getCurrentStore() {
    return _ref.apply(this, arguments);
  };
}();

var getCurrentUser = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/login/user');

          case 2:
            return _context2.abrupt('return', _context2.sent);

          case 3:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, _this$1);
  }));

  return function getCurrentUser() {
    return _ref2.apply(this, arguments);
  };
}();

var getCultures = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/cultures', null);

          case 2:
            return _context3.abrupt('return', _context3.sent);

          case 3:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, _this$1);
  }));

  return function getCultures() {
    return _ref3.apply(this, arguments);
  };
}();

var getCurrencies = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/currencies');

          case 2:
            return _context4.abrupt('return', _context4.sent);

          case 3:
          case 'end':
            return _context4.stop();
        }
      }
    }, _callee4, _this$1);
  }));

  return function getCurrencies() {
    return _ref4.apply(this, arguments);
  };
}();

var renewToken = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5() {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.post(config.getValue('apiUrl') + '/v1/store/login/renew');

          case 2:
            return _context5.abrupt('return', _context5.sent);

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, _this$1);
  }));

  return function renewToken() {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * Represent the store logic and API in the system
 */

var Store = function () {
  function Store() {
    _classCallCheck(this, Store);
  }

  /**
   * Set **state.currentStore** with the data of the store, that is associated with the security token and culture
   * in the request headers.
   * @returns {StoreModel} - the store data
   */
  Store.prototype.loadCurrentStore = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var currentStore;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return getCurrentStore();

            case 2:
              currentStore = _context.sent;

              providerState.dispatch({ type: LOAD_CURRENT_STORE, data: currentStore });
              return _context.abrupt('return', currentStore);

            case 5:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadCurrentStore() {
      return _ref.apply(this, arguments);
    }

    return loadCurrentStore;
  }();

  /**
   * Set **state.currentUser** with the user, that is logged-in to the store
   * @returns {UserModel} - the user data
   */


  Store.prototype.loadCurrentUser = function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
      var currentUser;
      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return getCurrentUser();

            case 2:
              currentUser = _context2.sent;

              providerState.dispatch({ type: LOAD_CURRENT_USER, data: currentUser });
              return _context2.abrupt('return', currentUser);

            case 5:
            case 'end':
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));

    function loadCurrentUser() {
      return _ref2.apply(this, arguments);
    }

    return loadCurrentUser;
  }();

  /**
   * Set **state.cultures** with the list of the cultures, that are set for the store.
   * @returns {CultureModel[]} - list of the cultures
   */


  Store.prototype.loadStoreCultures = function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3() {
      var cultures;
      return _regeneratorRuntime.wrap(function _callee3$(_context3) {
        while (1) {
          switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return getCultures();

            case 2:
              cultures = _context3.sent;

              providerState.dispatch({ type: LOAD_CULTURES, data: cultures });
              return _context3.abrupt('return', cultures);

            case 5:
            case 'end':
              return _context3.stop();
          }
        }
      }, _callee3, this);
    }));

    function loadStoreCultures() {
      return _ref3.apply(this, arguments);
    }

    return loadStoreCultures;
  }();

  /**
   * Set **state.currencies** with the list of the currencies, that are set for the store.
   * @returns {CurrencyModel[]} - list of the currencies
   */


  Store.prototype.loadStoreCurrencies = function () {
    var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4() {
      var currencies;
      return _regeneratorRuntime.wrap(function _callee4$(_context4) {
        while (1) {
          switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return getCurrencies();

            case 2:
              currencies = _context4.sent;

              providerState.dispatch({ type: LOAD_CURRENCIES, data: currencies });
              return _context4.abrupt('return', currencies);

            case 5:
            case 'end':
              return _context4.stop();
          }
        }
      }, _callee4, this);
    }));

    function loadStoreCurrencies() {
      return _ref4.apply(this, arguments);
    }

    return loadStoreCurrencies;
  }();

  return Store;
}();

var storeService = new Store();

var _this$2 = undefined;

var httpUpload = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(url, uploadedValue) {
    var token, contentLanguage, myHeaders, formData, requestOptions, promises;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            token = contextService.getValue('securityToken');
            contentLanguage = contextService.getValue('languageCode');
            myHeaders = new Headers();
            formData = new FormData();

            myHeaders.append('Authorization', 'uStore ' + token);
            myHeaders.append('Accept-Language', contentLanguage);

            uploadedValue.map(function (item) {
              return formData.append(encodeURIComponent(item.name), item, item.name);
            });

            requestOptions = {
              method: 'POST',
              headers: myHeaders,
              body: formData,
              redirect: 'follow'
            };
            _context.next = 10;
            return fetch(url, requestOptions).then(function (response) {
              return response.json();
            }).catch(function (error) {
              return console.log('error uploading', error);
            });

          case 10:
            promises = _context.sent;
            return _context.abrupt('return', _Promise.all([promises]));

          case 12:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this$2);
  }));

  return function httpUpload(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var _this$3 = undefined;

var httpDeleteFiles = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(url, name) {
    var token, myHeaders, requestOptions;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            token = contextService.getValue('securityToken');
            myHeaders = new Headers();

            myHeaders.append('Authorization', 'uStore ' + token);

            requestOptions = {
              method: 'DELETE',
              headers: myHeaders,
              body: name,
              redirect: 'follow'
            };
            return _context.abrupt('return', fetch(url, requestOptions).then(function (response) {
              return response.json();
            }).catch(function (error) {
              return console.log('error', error);
            }));

          case 5:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this$3);
  }));

  return function httpDeleteFiles(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var _this$4 = undefined;

var getUserOrdersSummary = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/login/user/orders/summary');

          case 2:
            return _context.abrupt('return', _context.sent);

          case 3:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this$4);
  }));

  return function getUserOrdersSummary() {
    return _ref.apply(this, arguments);
  };
}();

var addOrderItem = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(productID) {
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return http.post(config.getValue('apiUrl') + '/v1/store/login/user/orders/draft/items?productID=' + productID);

          case 2:
            return _context2.abrupt('return', _context2.sent);

          case 3:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, _this$4);
  }));

  return function addOrderItem(_x) {
    return _ref2.apply(this, arguments);
  };
}();

var getOrderItem = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            _context3.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID);

          case 2:
            return _context3.abrupt('return', _context3.sent);

          case 3:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, _this$4);
  }));

  return function getOrderItem(_x2) {
    return _ref3.apply(this, arguments);
  };
}();

var updateOrderItem = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.put(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID, orderItem);

          case 2:
            return _context4.abrupt('return', _context4.sent);

          case 3:
          case 'end':
            return _context4.stop();
        }
      }
    }, _callee4, _this$4);
  }));

  return function updateOrderItem(_x3, _x4) {
    return _ref4.apply(this, arguments);
  };
}();

var getPriceOrderItem = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(orderItemID, orderItem) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.post(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/price/calculate', orderItem);

          case 2:
            return _context5.abrupt('return', _context5.sent);

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, _this$4);
  }));

  return function getPriceOrderItem(_x5, _x6) {
    return _ref5.apply(this, arguments);
  };
}();

var reorder = function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            _context6.next = 2;
            return http.post(config.getValue('apiUrl') + '/v1/store/login/user/orders/submitted/items/' + orderItemID + '/reorder');

          case 2:
            return _context6.abrupt('return', _context6.sent);

          case 3:
          case 'end':
            return _context6.stop();
        }
      }
    }, _callee6, _this$4);
  }));

  return function reorder(_x7) {
    return _ref6.apply(this, arguments);
  };
}();

var getLastOrder = function () {
  var _ref7 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee7(productID) {
    return _regeneratorRuntime.wrap(function _callee7$(_context7) {
      while (1) {
        switch (_context7.prev = _context7.next) {
          case 0:
            _context7.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/login/user/orders/submitted/items/last/status?productID=' + productID);

          case 2:
            return _context7.abrupt('return', _context7.sent);

          case 3:
          case 'end':
            return _context7.stop();
        }
      }
    }, _callee7, _this$4);
  }));

  return function getLastOrder(_x8) {
    return _ref7.apply(this, arguments);
  };
}();

var addToCart = function () {
  var _ref8 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee8(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee8$(_context8) {
      while (1) {
        switch (_context8.prev = _context8.next) {
          case 0:
            _context8.next = 2;
            return http.post(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/addToCart');

          case 2:
            return _context8.abrupt('return', _context8.sent);

          case 3:
          case 'end':
            return _context8.stop();
        }
      }
    }, _callee8, _this$4);
  }));

  return function addToCart(_x9) {
    return _ref8.apply(this, arguments);
  };
}();

var saveForLater = function () {
  var _ref9 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee9(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee9$(_context9) {
      while (1) {
        switch (_context9.prev = _context9.next) {
          case 0:
            _context9.next = 2;
            return http.post(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/saveForLater');

          case 2:
            return _context9.abrupt('return', _context9.sent);

          case 3:
          case 'end':
            return _context9.stop();
        }
      }
    }, _callee9, _this$4);
  }));

  return function saveForLater(_x10) {
    return _ref9.apply(this, arguments);
  };
}();

var getDeliveryServices = function () {
  var _ref10 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee10(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee10$(_context10) {
      while (1) {
        switch (_context10.prev = _context10.next) {
          case 0:
            _context10.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/deliveryServices');

          case 2:
            return _context10.abrupt('return', _context10.sent);

          case 3:
          case 'end':
            return _context10.stop();
        }
      }
    }, _callee10, _this$4);
  }));

  return function getDeliveryServices(_x11) {
    return _ref10.apply(this, arguments);
  };
}();

var getProperties = function () {
  var _ref11 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee11(orderItemID) {
    return _regeneratorRuntime.wrap(function _callee11$(_context11) {
      while (1) {
        switch (_context11.prev = _context11.next) {
          case 0:
            _context11.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/properties/form');

          case 2:
            return _context11.abrupt('return', _context11.sent);

          case 3:
          case 'end':
            return _context11.stop();
        }
      }
    }, _callee11, _this$4);
  }));

  return function getProperties(_x12) {
    return _ref11.apply(this, arguments);
  };
}();

var updateProperties = function () {
  var _ref12 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee12(orderItemID, data) {
    return _regeneratorRuntime.wrap(function _callee12$(_context12) {
      while (1) {
        switch (_context12.prev = _context12.next) {
          case 0:
            _context12.next = 2;
            return http.put(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/properties/form', data);

          case 2:
            return _context12.abrupt('return', _context12.sent);

          case 3:
          case 'end':
            return _context12.stop();
        }
      }
    }, _callee12, _this$4);
  }));

  return function updateProperties(_x13, _x14) {
    return _ref12.apply(this, arguments);
  };
}();

var updatePropertiesState = function () {
  var _ref13 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee13(orderItemID, data) {
    return _regeneratorRuntime.wrap(function _callee13$(_context13) {
      while (1) {
        switch (_context13.prev = _context13.next) {
          case 0:
            _context13.next = 2;
            return http.put(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/properties/form/state', data);

          case 2:
            return _context13.abrupt('return', _context13.sent);

          case 3:
          case 'end':
            return _context13.stop();
        }
      }
    }, _callee13, _this$4);
  }));

  return function updatePropertiesState(_x15, _x16) {
    return _ref13.apply(this, arguments);
  };
}();

var uploadFile = function () {
  var _ref14 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee14(orderItemID, propertyID, data) {
    return _regeneratorRuntime.wrap(function _callee14$(_context14) {
      while (1) {
        switch (_context14.prev = _context14.next) {
          case 0:
            _context14.next = 2;
            return httpUpload(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/properties/' + propertyID + '/files', data);

          case 2:
            return _context14.abrupt('return', _context14.sent);

          case 3:
          case 'end':
            return _context14.stop();
        }
      }
    }, _callee14, _this$4);
  }));

  return function uploadFile(_x17, _x18, _x19) {
    return _ref14.apply(this, arguments);
  };
}();

var deleteFiles = function () {
  var _ref15 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee15(orderItemID, propertyID, names) {
    return _regeneratorRuntime.wrap(function _callee15$(_context15) {
      while (1) {
        switch (_context15.prev = _context15.next) {
          case 0:
            _context15.next = 2;
            return httpDeleteFiles(config.getValue('apiUrl') + '/v1/store/login/user/orders/unsubmitted/items/' + orderItemID + '/properties/' + propertyID + '/files?' + names);

          case 2:
            return _context15.abrupt('return', _context15.sent);

          case 3:
          case 'end':
            return _context15.stop();
        }
      }
    }, _callee15, _this$4);
  }));

  return function deleteFiles(_x20, _x21, _x22) {
    return _ref15.apply(this, arguments);
  };
}();

var getRepositoryDetails = function () {
  var _ref16 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee16(guid) {
    return _regeneratorRuntime.wrap(function _callee16$(_context16) {
      while (1) {
        switch (_context16.prev = _context16.next) {
          case 0:
            _context16.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/system/fileRepositories/' + guid);

          case 2:
            return _context16.abrupt('return', _context16.sent);

          case 3:
          case 'end':
            return _context16.stop();
        }
      }
    }, _callee16, _this$4);
  }));

  return function getRepositoryDetails(_x23) {
    return _ref16.apply(this, arguments);
  };
}();

var _this$5 = undefined;

var getProductIDByFriendlyID = function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(friendlyID) {
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/products/id?friendlyID=' + friendlyID);

          case 2:
            return _context.abrupt('return', _context.sent);

          case 3:
          case 'end':
            return _context.stop();
        }
      }
    }, _callee, _this$5);
  }));

  return function getProductIDByFriendlyID(_x) {
    return _ref.apply(this, arguments);
  };
}();

var getProducts = function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(categoryID, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            params = convertObjectToQueryString({ pageNumber: pageNumber, pageSize: pageSize });
            _context2.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/categories/' + categoryID + '/products' + (params.length ? '?' + params : ''));

          case 3:
            return _context2.abrupt('return', _context2.sent);

          case 4:
          case 'end':
            return _context2.stop();
        }
      }
    }, _callee2, _this$5);
  }));

  return function getProducts(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();

var getProductsByIDs = function () {
  var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee3(IDs) {
    var sIDs;
    return _regeneratorRuntime.wrap(function _callee3$(_context3) {
      while (1) {
        switch (_context3.prev = _context3.next) {
          case 0:
            sIDs = IDs.map(function (val, ind) {
              return 'productIDs[' + ind + ']=' + val;
            }).join('&');
            _context3.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/products?' + sIDs);

          case 3:
            return _context3.abrupt('return', _context3.sent);

          case 4:
          case 'end':
            return _context3.stop();
        }
      }
    }, _callee3, _this$5);
  }));

  return function getProductsByIDs(_x5) {
    return _ref3.apply(this, arguments);
  };
}();

var getProductByID = function () {
  var _ref4 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee4(productID, retrieveTypeSpecificData) {
    return _regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            _context4.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/products/' + productID + '?retrieveTypeSpecificData=' + retrieveTypeSpecificData);

          case 2:
            return _context4.abrupt('return', _context4.sent);

          case 3:
          case 'end':
            return _context4.stop();
        }
      }
    }, _callee4, _this$5);
  }));

  return function getProductByID(_x6, _x7) {
    return _ref4.apply(this, arguments);
  };
}();

var getProductThumbnails = function () {
  var _ref5 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee5(productID) {
    return _regeneratorRuntime.wrap(function _callee5$(_context5) {
      while (1) {
        switch (_context5.prev = _context5.next) {
          case 0:
            _context5.next = 2;
            return http.get(config.getValue('apiUrl') + '/v1/store/products/' + productID + '/thumbnails');

          case 2:
            return _context5.abrupt('return', _context5.sent);

          case 3:
          case 'end':
            return _context5.stop();
        }
      }
    }, _callee5, _this$5);
  }));

  return function getProductThumbnails(_x8) {
    return _ref5.apply(this, arguments);
  };
}();

var search = function () {
  var _ref6 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee6(_search, pageNumber, pageSize) {
    var params;
    return _regeneratorRuntime.wrap(function _callee6$(_context6) {
      while (1) {
        switch (_context6.prev = _context6.next) {
          case 0:
            params = convertObjectToQueryString({ search: _search, pageNumber: pageNumber, pageSize: pageSize });
            _context6.next = 3;
            return http.get(config.getValue('apiUrl') + '/v1/store/products/search' + (params.length ? '?' + params : ''));

          case 3:
            return _context6.abrupt('return', _context6.sent);

          case 4:
          case 'end':
            return _context6.stop();
        }
      }
    }, _callee6, _this$5);
  }));

  return function search(_x9, _x10, _x11) {
    return _ref6.apply(this, arguments);
  };
}();

var productType = {
  Undefined: -1,
  Dynamic: 1,
  Static: 2,
  Email: 3,
  Uploaded: 4,
  Composite: 5,
  DynamicWithPurl: 6,
  EmailWithPurl: 7,
  CircleProject: 8,
  PrintTouchPoint: 9,
  EmailTouchPoint: 10,
  WebTouchPoint: 11,
  PdfOnDemandTouchPoint: 12,
  TriggeredEmailTouchPoint: 13,
  Kit: 14
};

var api = {

  categories: {
    getTopCategories: getTopCategories,
    getSubCategories: getSubCategories,
    getCategoryIDByFriendlyID: getCategoryIDByFriendlyID,
    getCategory: getCategory,
    getCategoryTree: getCategoryTree
  },
  orders: {
    getUserOrdersSummary: getUserOrdersSummary,
    addOrderItem: addOrderItem,
    getOrderItem: getOrderItem,
    updateOrderItem: updateOrderItem,
    getPriceOrderItem: getPriceOrderItem,
    reorder: reorder,
    getLastOrder: getLastOrder,
    addToCart: addToCart,
    saveForLater: saveForLater,
    getDeliveryServices: getDeliveryServices,
    getProperties: getProperties,
    updateProperties: updateProperties,
    updatePropertiesState: updatePropertiesState,
    getRepositoryDetails: getRepositoryDetails,
    uploadFile: uploadFile,
    deleteFiles: deleteFiles
  },
  products: {
    getProductIDByFriendlyID: getProductIDByFriendlyID,
    getProducts: getProducts,
    getProductByID: getProductByID,
    productType: productType,
    getProductsByIDs: getProductsByIDs,
    getProductThumbnails: getProductThumbnails,
    search: search
  },
  store: {
    getCurrentStore: getCurrentStore,
    getCurrentUser: getCurrentUser,
    getCultures: getCultures,
    getCurrencies: getCurrencies,
    renewToken: renewToken
  }

};

var InitialState = function () {
  function InitialState() {
    _classCallCheck(this, InitialState);
  }

  InitialState.prototype.loadInitialState = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var currencyFriendlyID, currentCurrency, currencyID;
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return storeService.loadCurrentStore();

            case 2:
              _context.next = 4;
              return storeService.loadStoreCultures();

            case 4:

              cultureService.setCurrentCultureByLanguage(contextService.getValue('languageCode'));

              _context.next = 7;
              return storeService.loadStoreCurrencies();

            case 7:
              currencyFriendlyID = contextService.getValue('currencyFriendlyID');
              currentCurrency = providerState.get().currencies.filter(function (c) {
                return c.FriendlyID === parseInt(currencyFriendlyID);
              })[0];
              currencyID = contextService.getValue('currencyID');


              if (currencyID) {
                currentCurrency = providerState.get().currencies.filter(function (c) {
                  return c.ID === currencyID;
                })[0];
              }
              cultureService.setCurrentCurrency(currentCurrency);

              _context.next = 14;
              return storeService.loadCurrentUser();

            case 14:

              // raise flag that initial state was loaded in order not to do it again
              providerState.setInitState();

            case 15:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function loadInitialState() {
      return _ref.apply(this, arguments);
    }

    return loadInitialState;
  }();

  return InitialState;
}();

var initialStateService = new InitialState();

var newState = {
  culture: cultureService,
  store: storeService,
  categories: categories,
  products: products,
  get: function get() {
    return providerState.get();
  },
  set: function set(state) {
    return providerState.set(state);
  },
  dispatch: providerState.dispatch,
  subscribe: providerState.subscribe,
  customState: {
    set: function set(name, value) {
      return providerState.setCustomState(name, value);
    },
    setBulk: function setBulk(obj) {
      return providerState.setBulkCustomState(obj);
    },
    get: function get(name) {
      return name ? providerState.get().customState[name] : providerState.get().customState;
    },
    delete: function _delete(name) {
      return providerState.deleteCustomState(name);
    },
    merge: function merge(customState) {
      return providerState.mergeCustomState(customState);
    }
  }
};

/**
 * UStoreProvider - This is the uStore provider - the entry point to all ustore API's
 */

var Provider = function () {
  function Provider() {
    _classCallCheck(this, Provider);

    this.stateService = providerState;
    this.binding = bindingService;
    this.initialState = initialStateService;
    this.configService = config;
    this.contextService = contextService;
  }

  Provider.prototype.init = function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(runtimeConfig, params) {
      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (runtimeConfig) {
                this.configService.set(runtimeConfig);
              }

              if (!params) {
                _context.next = 6;
                break;
              }

              this.contextService.set(params);

              if (!this.stateService.get().initState) {
                _context.next = 6;
                break;
              }

              _context.next = 6;
              return this.initialState.loadInitialState();

            case 6:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function init(_x, _x2) {
      return _ref.apply(this, arguments);
    }

    return init;
  }();

  _createClass(Provider, [{
    key: 'api',
    get: function get$$1() {
      return api;
    }
  }, {
    key: 'state',
    get: function get$$1() {
      return newState;
    }
  }]);

  return Provider;
}();

var UStoreProvider = new Provider();
// expose UStoreProvider on window so standalone component will have access to it
// which will allow them to register and let the provider add model binding and
// action changing
if (typeof window !== 'undefined') {
  window.UStoreProvider = UStoreProvider;
}

export { http, UStoreProvider };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
