import React, { Component } from "react"
import './Footer.scss'
import { Router, Link } from '$routes'
import { t } from '$themelocalization'
import { getVariableValue } from '$ustoreinternal/services/cssVariables'

/**
 * This component represents the footer in the store
 */
class Footer extends Component {
  render() {
    const footerLogo = getVariableValue('--cust-footer-logo', require(`$assets/images/xmpie-logo.png`), true);
    const heading1 = getVariableValue('--cust-footer-column1-header', t('footerHeader1'));
    const heading2 = getVariableValue('--cust-footer-column2-header', t('footerHeader2'));
    const textCol1row1 = getVariableValue('--cust-footer-column1-row1', t('footerCol1Row1'));
    const textCol1row2 = getVariableValue('--cust-footer-column1-row2', t('footerCol1Row2'));
    const textCol1row3 = getVariableValue('--cust-footer-column1-row3', t('footerCol1Row3'));
    const linkCol1row1 = getVariableValue('--cust-footer-column1-row1-link', '', false, true);
    const linkCol1row2 = getVariableValue('--cust-footer-column1-row2-link', '', false, true);
    const linkCol1row3 = getVariableValue('--cust-footer-column1-row3-link', '', false, true);
    const textCol2row1 = getVariableValue('--cust-footer-column2-row1', t('footerCol2Row1'));
    const textCol2row2 = getVariableValue('--cust-footer-column2-row2', t('footerCol2Row2'));
    const textCol2row3 = getVariableValue('--cust-footer-column2-row3', t('footerCol2Row3'));
    const linkCol2row1 = getVariableValue('--cust-footer-column2-row1-link', '', false, true);
    const linkCol2row2 = getVariableValue('--cust-footer-column2-row2-link', '', false, true);
    const linkCol2row3 = getVariableValue('--cust-footer-column2-row3-link', '', false, true);
    const textCol3row1 = getVariableValue('--cust-footer-column3-row1', t('footerCol3Row1'));
    const textCol3row2 = getVariableValue('--cust-footer-column3-row2', t('footerCol3Row2'));
    const textCol3row3 = getVariableValue('--cust-footer-column3-row3', t('footerCol3Row3'));
    const linkCol3row1 = getVariableValue('--cust-footer-column3-row1-link', '', false, true);
    const linkCol3row2 = getVariableValue('--cust-footer-column3-row2-link', '', false, true);
    const linkCol3row3 = getVariableValue('--cust-footer-column3-row3-link', '', false, true);
    const logoLink = getVariableValue('--cust-footer-logo-link', '', false, true);
    const cyear = new Date().getFullYear();
    const copyrightText = getVariableValue('--cust-footer-copyright', t('footerCopyright')).replace("(year)",cyear);

    let link11;
    if (linkCol1row1.length > 0 && linkCol1row1.substring(0,4).toLowerCase() == 'http') {
      link11 = <div className="footLink"><a id="footer-c1r1" href={linkCol1row1}>{textCol1row1}</a></div>;
    } else if (linkCol1row1.length > 0) {
      link11 = <div className="footLink"><Link to={linkCol1row1}><a id="footer-c1r1">{textCol1row1}</a></Link></div>;
    } else {
      link11 = <div className="footText">{textCol1row1}</div>;
    }
    let link12;
    if (linkCol1row2.length > 0 && linkCol1row2.substring(0,4).toLowerCase() == 'http') {
      link12 = <div className="footLink"><a id="footer-c1r2" href={linkCol1row2}>{textCol1row2}</a></div>;
    } else if (linkCol1row2.length > 0) {
      link12 = <div className="footLink"><Link to={linkCol1row2}><a id="footer-c1r1">{textCol1row2}</a></Link></div>;
    } else {
      link12 = <div className="footText">{textCol1row2}</div>;
    }
    let link13;
    if (linkCol1row3.length > 0 && linkCol1row3.substring(0,4).toLowerCase() == 'http') {
      link13 = <div className="footLink"><a id="footer-c1r3" href={linkCol1row3}>{textCol1row3}</a></div>;
    } else if (linkCol1row3.length > 0) {
      link13 = <div className="footLink"><Link to={linkCol1row3}><a id="footer-c1r3">{textCol1row3}</a></Link></div>;
    } else {
      link13 = <div className="footText">{textCol1row3}</div>;
    }
    let link21;
    if (linkCol2row1.length > 0 && linkCol2row1.substring(0,4).toLowerCase() == 'http') {
      link21 = <div className="footLink"><a id="footer-c2r1" href={linkCol2row1}>{textCol2row1}</a></div>;
    } else if (linkCol2row1.length > 0) {
      link21 = <div className="footLink"><Link to={linkCol2row1}><a id="footer-c2r1">{textCol2row1}</a></Link></div>;
    } else {
      link21 = <div className="footText">{textCol2row1}</div>;
    }
    let link22;
    if (linkCol2row2.length > 0 && linkCol2row2.substring(0,4).toLowerCase() == 'http') {
      link22 = <div className="footLink"><a id="footer-c2r2" href={linkCol2row2}>{textCol2row2}</a></div>;
    } else if (linkCol2row2.length > 0) {
      link22 = <div className="footLink"><Link to={linkCol2row2}><a id="footer-c2r2">{textCol2row2}</a></Link></div>;
    } else {
      link22 = <div className="footText">{textCol2row2}</div>;
    }
    let link23;
    if (linkCol2row3.length > 0 && linkCol2row3.substring(0,4).toLowerCase() == 'http') {
      link23 = <div className="footLink"><a id="footer-c2r3" href={linkCol2row3}>{textCol2row3}</a></div>;
    } else if (linkCol2row3.length > 0) {
      link23 = <div className="footLink"><Link to={linkCol2row3}><a id="footer-c2r3">{textCol2row3}</a></Link></div>;
    } else {
      link23 = <div className="footText">{textCol2row3}</div>;
    }
    let linklogo;
    if (logoLink.length > 0 && logoLink.substring(0,4).toLowerCase() == 'http') {
      linklogo = <a id="footer-logo-link" href={logoLink}><img src={footerLogo} className="footerLogo" /></a>;
    } else if (logoLink.length > 0) {
      linklogo = <Link to={logoLink}><a id="footer-logo-link"><img src={footerLogo} className="footerLogo" /></a></Link>;
    } else {
      linklogo = <img src={footerLogo} className="footerLogo" />;
    }
    let link31;
    if (linkCol3row1.length > 0 && linkCol3row1.substring(0,4).toLowerCase() == 'http'){
      link31 = <div className="companyLink companyName"><a id="footer-c3r1" href={linkCol3row1}>{textCol3row1}</a></div>;
    } else if (linkCol3row1.length > 0) {
      link31 = <div className="companyLink companyName"><Link to={linkCol3row1}><a id="footer-c3r1">{textCol3row1}</a></Link></div>;
    } else {
      link31 = <div className="companyLink companyName">{textCol3row1}</div>;
    }
    let link32;
    if (linkCol3row2.length > 0 && linkCol3row2.substring(0,4).toLowerCase() == 'http'){
      link32 = <div className="companyLink"><a id="footer-c3r2" href={linkCol3row2}>{textCol3row2}</a></div>;
    } else if (linkCol3row2.length > 0) {
      link32 = <div className="companyLink"><Link to={linkCol3row2}><a id="footer-c3r2">{textCol3row2}</a></Link></div>;
    } else {
      link32 = <div className="companyLink">{textCol3row2}</div>;
    }
    let link33;
    if (linkCol3row3.length > 0 && linkCol3row3.substring(0,4).toLowerCase() == 'http'){
      link33 = <div className="companyLink"><a id="footer-c3r3" href={linkCol3row3}>{textCol3row3}</a></div>;
    } else if (linkCol3row3.length > 0) {
      link33 = <div className="companyLink"><Link to={linkCol3row3}><a id="footer-c3r3">{textCol3row3}</a></Link></div>;
    } else {
      link33 = <div className="companyLink">{textCol3row3}</div>;
    }

    return (
      <div className="footer">
        <div class="footer-row">
          <div id="footer-column-one" className="footer-column">
            <div className="footHeading" id="footer-column-one-header">{heading1}</div>
            {link11}
            {link12}
            {link13}
          </div>
          <div id="footer-column-two" className="footer-column">
          <div className="footHeading" id="footer-column-two-header">{heading2}</div>
            {link21}
            {link22}
            {link23}
          </div>
          <div  id="footer-column-three" className="footer-column">
          <div className="footer-logo-container">
            {linklogo}
          </div>
            {link31}
            {link32}
            {link33}
          </div>
        </div>
        <div class="footerLastRow">{copyrightText}</div>
      </div>
    )
  }
}
export default Footer
