export interface UEditOptions {
  width?: string | number;
  height?: string | number;
  pageViewMargins?: number;
  showProgressOnRead?: boolean;
  showProgressOnWrite?: boolean;
  progressTimeout?: number;
  showMarginGuides?: boolean;
  viewMode?: string;
  showPagesMask?: boolean;
  keyMoveDistance?: number;
  shiftKeyMoveDistance?: number;
  showCustomSelection?: boolean;
  useCustomSelection?: boolean;
  dontHandleKeys?: Record<string, boolean>;
  defaultFontData?: {
    css: {
      fontFamily: string;
    };
  };
  resizeDefaultProportional?: boolean;
  resizeDefaultScale?: boolean;
  editTextsInStoryView?: boolean;
  openMode?: 'Document' | 'Text' | 'FlatDesign';
  blockPostPopulationTreatmentsOnDefault?: boolean;
  ghostResize?: string;
  ghostRotate?: string;
  ghostMove?: string;
  rotateMarksStyle?: string;
  pinchZoomLowLimit?: number;
  rotateFromBoxEdges?: boolean;
  avoidHDTextResize?: boolean;
  avoidHDTextResizeCaretEmulation?: boolean;
  readyFontTimeout?: number | null;
  userImageTransformCancelsFittingMode?: boolean;
  optimizeTyping?: boolean;
  listExtraBehavior?: boolean;
  nativeViewScale?: number;
  zoomOnPinchGesture?: boolean;
  rotateOnRotateGesture?: boolean;
  richTextEditTopIsLeading?: boolean;
  uEditPICssClass?: string;
  uEditMarginClass?: string;
}


export type UEdit = {
  options: UEditOptions;
  $window: JQuery<Window>;
  $element: JQuery<HTMLElement>;
  uEditHammer: any;
  scaleFactor: number;
  translateX: number;
  translateY: number;
  progress: { progress: number; total: number };

  setupDocument(inDocument: any): this;
  setupText(inText: any): this;
  startProgressDialog(title: string): void;
  updateProgress(amount: number): void;
  hideProgressDialog(): void;
  updateProgressTitle(inTitle: string): void;
  getProgress(): { progress: number; total: number };
  setupFromXLIM(inXLIMFileData: string, inSyncRead?: boolean): void;
  setup(inXLIMFileData: string, inSyncRead: boolean): void;
  continueSetup(editorParams: any): void;
  setupFromXNIP(inXLIMFileData: string, inSyncRead: boolean): void;
  updateProgressMember(inProgress: number, inTotal: number): void;
  getDocument(): any;
  getText(): any;
  getContent(): any;
  writeToXLIM(inSyncWrite: boolean): any;
  writeToXNIP(inSyncWrite: boolean): any;
  continueWrite(): any;
  setTransform(): void;
  zoom(inZoomFactor: number): void;
  _zoom(inZoomNumber: number): void;
  pinchZoom(inEvent: any): void;
  goToPage(inPageIndex: number): void;
  goToActualPage(inPageIndex: number): void;
  saveDocumentViewPosition(): void;
  restoreDocumentViewPosition(): void;
  fitToPage(): this;
  fillWithPage(): this;
  SetEditorSize(initialClientHeight: number): this;
  getPasteboardSize(): { width: number; height: number };
  getPageInView(): any;
  getActualPageInView(): any;
  notifyPageChanged(inEventObject: any): void;
  setViewMode(inViewMode: string): void;
  select(inBoxToSelect: any): void;
  getSelection(): any;
  getSelectionViewData(): any;
  selectText(inTextStart: number, inTextLength: number, inTextBox: any): void;
  getTextSelection(): any;
  applyParagraphPropertiesOnSelection(inParagraphProperties: any, inIgnoreLocks: boolean): void;
  removeLockedParagraphOverrides(inParagraphOverrides: any, inIgnoreLocks: boolean): any;
  removeBoxOfSelection(inIgnoreLocks: boolean): void;
  removeSelection(inIgnoreLocks: boolean): void;
  getBoxOfSelection(): any;
  applyTextOverridesOnSelection(inTextProperties: any, inIgnoreLocks: boolean): void;
  removeLockedTextOverrides(inTextOverrides: any, inIgnoreLocks: boolean): any;
  applyTextADOROnTextSelection(inADORName: string, inReplacementText: string, inIgnoreFlags: boolean): void;
  insertInlineBoxInSelection(inBox: any, inIgnoreFlags: boolean): void;
  getTextPropertiesOnRange(inStart: number, inLength: number): any;
  getParagraphPropertiesOnRange(inStart: number, inLength: number): any;
  startTextEdit(inTextBox: any): void;
  endTextEdit(): void;
  isEditingText(): boolean;
  getViewData(inItem: any): any;
  getPageViewData(inPage: any): any;
  getDocumentView(): UEditDocumentView | UEditDocumentFlatDesignView;
  getStoryView(): UEditStoryView;
  addImageMapping(inImageLabel: string, inRealImageURL: string): void;
  removeImageMapping(inImageLabel: string): void;
  setImageMappingMethod(inImageMappingMethod: Function, inReverseImageMappingMethod: Function): void;
  addFontMapping(inFontDescriptor: any, inFontData: any): void;
  removeFontMapping(inFontDescriptor: any): void;
  setFontMappingMethod(inFontMappingMethod: Function): void;
  addTextFileMapping(inFileLabel: string, inRealURL: string): void;
  removeTextFileMapping(inFileLabel: string): void;
  setTextFileMappingMethod(inFileMappingMethod: Function): void;
  setChartProviderMethod(inChartProviderMethod: Function): void;
  highlightDynamicObjects(inDoHighlight: boolean): void;
  createDocument(): UEditDocument;
  showPreviewValues(): void;
  showDefaultValues(): void;
  getLockLogic(): any;
  getPreviewValuesObject(): any;
  saveScrollPosition(): void;
  restoreScrollPosition(): void;
  editTextsInStoryView(): void;
  editTextsInDocumentView(): void;
  endCurrentDocumentStoryEdit(): void;
  focusOnBox(inBox: any, inNoZoom: boolean): void;
  getFontRespository(): any;
  getImageRespository(): any;
  getPreview(): any;
  getUndoService(): any;
  getUndoMonitor(): any;
  getDocumentMonitor(): any;
  focus(): void;
  registerEvent(element: HTMLElement, event: string, callback: Function): void;
  unregisterEvent(element: HTMLElement, event: string, callback: Function): void;
}

export function createUEdit(element: HTMLElement, options: UEditOptions): UEdit


declare class UEditBox {
  static eTypeText: number;
  static eTypeGraphic: number;
  static eTypeLine: number;
  static eTypeUnkown: number;

  onTypeChanged(): void;

  forbidChangedOnLine(): void;

  setTopLeftWidthHeightPerLineCoordinates(): void;

  onParentChanged(inEvent: any): void;

  setBackgroundColor(inColor: any, inShade: number): this;

  setBorder(inColor: any, inShade: number, inWeight: number): this;

  setLine(inColor: any, inShade: number, inWeight: number): this;

  hasBorder(): boolean;

  getAffectiveBorder(): number;

  sendToBack(): this;

  bringToFront(): this;

  sendBackward(): this;

  bringForward(): this;

  remove(): this;

  detachFromPage(): this;

  duplicate(inParent: any, inDontDuplicateText?: boolean): UEditBox;

  moveBy(x: number, y: number): this;

  widenTo(inNewWidth: number): this;

  heightenTo(inNewHeight: number): this;

  unlinkTextFrame(): void;

  linkTextFrameToText(inText: UEditText, inAfterFrame: UEditBox): void;

  getPreviousTextFrame(): UEditBox | null;

  getNextTextFrame(): UEditBox | null;

  hasADORs(): boolean;

  isInline(): boolean;

  prototypeforbidPropertyChangeIfAnchor(prop: string, handler?: Function): void;
}

export type UEditText = {
  duplicate(inFrameForText?: any): UEditText;
  appendFrame(inFrame: any): void;
  insertFrame(inFrame: any, inIndex: number): void;
  removeFrame(inFrame: any): void;
  duplicateStream(inOtherText: UEditText): void;
  remove(): UEditText;
  hasADORs(): boolean;
  appendMark(inMark: any, inOwnerMark?: any): void;
  appendMarks(inMarks: any[], inOwnerMark?: any): void;
  insertMarks(inMarks: any[], inInsertionIndex: number, inOwnerMark?: any): void;
  removeMarks(inMarksIndexes: number[]): void;
  indexOfMark(inMark: any): number;
  calculateAffectiveTextProperties(inMark: any): any;
  calculateAffectiveParagraphProperties(inParagraphMark: any): UEditParagraphProperties;
  findParagraphOfMarkIndex(inMarkIndex: number): any;
  appendText(inText: any, inADOR?: any): void;
  appendInlineBox(inBox: any): void;
  findFirstMarkAtTextIndex(inTextIndex: number): any;
  findFirstContentMarkAtTextIndex(inTextIndex: number): any;
  applyTextOverridesForTextIndex(inTextProperties: any, inStartIndex: number, inLength: number): void;
  applyTextOverridesOnMarks(inTextProperties: any, inStartMarkIndex: number, inLength?: number): number;
  removeForTextIndex(inStartIndex: number, inLength: number): void;
  appendParagraph(inParagraphMark?: any): void;
  insertParagraph(inIndex: number, inParagraphMark?: any, inInitialOverrides?: any): void;
  duplicateAffectiveOverrideForTextIndex(inTextIndex: number): void;
  duplicateAffectiveOverrideOnParagraphText(inMarkIndex: number): any;
  insertText(inIndex: number, inText: any, inADOR?: any): void;
  insertInlineBox(inIndex: number, inBox: any): void;
  insertMarksAtTextPosition(inIndex: number, inMarks: any[]): void;
  getTextIndexOfMark(inMark: any): number;
  getTextLength(): number;
  isEmpty(): boolean;
  getText(inStart?: number, inLength?: number): string;
  getMarksInRange(inStart: number, inLength: number): any[];
  applyParagraphOverridesForTextIndex(inParagraphProperties: any, inStart: number, inLength: number): void;
  getOwnedMarks(inOwnerMark: any): any[];
  getOwnedMarksIndexes(inOwnerMark: any): number[];
  removeOwnedMarks(inOwnerMark: any): void;
  duplicateCopyFittingAlgorithms(): any[];
  setTextFeaturesModifiers(inModifiers: any): void;
  resetTextFeaturesModifiers(): void;
  removeCopyFittingAlgorithm(inCopyFittingAlgorithm: any): void;
  popCopyFittingAlgorithm(): void;
  addCopyFittingAlgorithm(inCopyFittingAlgorithm: any, inIndex: number): void;
  pushCopyFittingAlgorithm(inCopyFittingAlgorithm: any): void;
  modifyCopyFittingAlgorithm(inIndex: number, inProperties: any): void;
  hasAutoFlow(): boolean;
  hasCopyFit(): boolean;
}

export interface XLIMColorProperties {
  mID: number;
  mSeps: number[] | null;
  mIsTransparent: boolean;
}

declare class XLIMColor {
  constructor(public kind: string, public mSeps?: number[] | null, public mIsTransparent?: boolean, public mID?: number);

  isNotEqualRGB(inRGB: XLIMColor): boolean;

  sepsNotEqual(inXLIMColor: XLIMColor): boolean;

  cloneAs(kind: string): XLIMColor;

  asString(): string;

  toString(): string;
}

export class UXLIMAttribute {
  constructor(inKind: any);

  static eMasterName: number;
  static eUCreateSpreadID: number;
  static eUCreateLayerID: number;
  static eID: number;
  static eUCreateParentID: number;
  static ePageHeight: number;
  static ePageWidth: number;
  static eSrc: number;
  static eScaling: number;
  static eUCreateFittingMode: number;
  static eUCreateCopyFitting: number;
  static eUCreateAutoFlow: number;
  static eContentHeight: number;
  static eContentWidth: number;
  static eLeft: number;
  static eTop: number;
  static eWidth: number;
  static eHeight: number;
  static eColor: number;
  static eUCreateBorderColor: number;
  static eBackgroundColor: number;
  static eUCreateCMYKColor: number;
  static eUCreateCMYKBorderColor: number;
  static eUCreateCMYKBackgroundColor: number;
  static eUCreateShade: number;
  static eUCreateBackgroundShade: number;
  static eUCreateRotation: number;
  static eUCreateBorderWeight: number;
  static eUCreateBorderShade: number;
  static ePosition: number;
  static eFontFamily: number;
  static eFontSize: number;
  static eFontWeight: number;
  static eFontStyle: number;
  static eFontPSName: number;
  static eFontFullName: number;
  static eFontFaceName: number;
  static eFontUID: number;
  static eTextAlign: number;
  static eTextAlignLast: number;
  static eLinefeedTreatment: number;
  static eRole: number;
  static eXMLNS: number;
  static eMarginTop: number;
  static eMarginBottom: number;
  static eMarginLeft: number;
  static eMarginRight: number;
  static eBleedTop: number;
  static eBleedBottom: number;
  static eBleedInside: number;
  static eBleedOutside: number;
  static ePagesPerSpread: number;
  static eMasterReference: number;
  static eFlowName: number;
  static eBorder: number;
  static eXMLNSUCreate: number;
  static eUCreatePlan: number;
  static eUCreatePlanXML: number;
  static eUCreateProofSet: number;
  static eUCreateName: number;
  static eVisibility: number;
  static eUCreateUIVisibility: number;
  static eUCreateMedia: number;
  static eUCreateTransformation: number;
  static eUCreateWeight: number;
  static eUCreateX1: number;
  static eUCreateX2: number;
  static eUCreateY1: number;
  static eUCreateY2: number;
  static eUCreateThreshold: number;
  static eUCreateTextPosition: number;
  static eUCreateSuperscriptSettings: number;
  static eUCreateSubscriptSettings: number;
  static eUCreateSpaceBefore: number;
  static eUCreateSpaceAfter: number;
  static eUCreateVTextAlign: number;
  static eUCreateTabSettings: number;
  static eUCreateTextLIndent: number;
  static eUCreateTextRIndent: number;
  static eUCreateParagraphSpacingLimit: number;
  static eUCreateInsetsTop: number;
  static eUCreateInsetsBottom: number;
  static eUCreateInsetsLeft: number;
  static eUCreateInsetsRight: number;
  static eUCreateEnvSrc: number;
  static eUCreateLock: number;
  static eUCreatePrintability: number;
  static eDDGXMLData: number;
  static eUCreateText1LIndent: number;
  static eTextLeading: number;
  static eAutoLeading: number;
  static eUCreateBNList: number;
  static eUCreateDocPrefsXML: number;
  static eUCreateVersion: number;
  static eUCreateKerning: number;
  static eUCreateTracking: number;
  static eUCreateFoldStory: number;
  static eUCreateFoldTables: number;
  static eUCreateUnderline: number;
  static eUCreateUnderlineStyle: number;
  static eUCreateUnderlineOffset: number;
  static eUCreateUnderlineWeight: number;
  static eUCreateUnderlineColor: number;
  static eUCreateUnderlineShade: number;
  static eUCreateUnderlineGapColor: number;
  static eUCreateUnderlineGapShade: number;
  static eUCreateStrikeThrough: number;
  static eUCreateStrikeThroughStyle: number;
  static eUCreateStrikeThroughOffset: number;
  static eUCreateStrikeThroughWeight: number;
  static eUCreateStrikeThroughColor: number;
  static eUCreateStrikeThroughShade: number;
  static eUCreateStrikeThroughGapColor: number;
  static eUCreateStrikeThroughGapShade: number;
  static eUCreateSpotColor: number;
  static eInvalid: number;
  static eEndOfAttrList: number;

  static kAttributeNames: string[];

  static kXMLNSFOProperty: string;
  static kXMLNSUCreateProperty: string;

  static kErrorLevels: string[];

  static eNumAttributes: number;
}


declare class UEditTextProperties {
  color: string | null;
  shade: number | null;
  _leading: number | null;
  autoLeading: number | null;
  manualKerning: boolean | null;
  kerningMeasure: number | null;
  tracking: number | null;
  textPosition: XLIMTextPosition | null;
  _fontSize: number | null;
  fontDescriptor: any | null;
  leadingModifier: number | null;
  fontSizeModifier: number | null;
  underlineDescriptor: any | null;
  strikethroughDescriptor: any | null;

  constructor(inAnother?: UEditTextProperties);

  static DEFAULT_FONT_SIZE: number;
  static Default: UEditTextProperties;

  setColor(inColor: string, inShade: number): this;

  isEmpty(): boolean;

  hasTextMeasureChangingFeatures(): boolean;

  duplicate(): UEditTextProperties;

  inherit(inOther: UEditTextProperties): void;

  calculateNewFeaturesNames(inOther: UEditTextProperties): string[];

  derive(inOther: UEditTextProperties): void;

  overrideWith(inOther: UEditTextProperties): void;

  isEqual(inOther: UEditTextProperties): boolean;

  derivedOrEqual(inOther: UEditTextProperties): boolean;

  setModifiers(inModifiers: { leading: number; fontSize: number }): void;
}


declare class UEditParagraphProperties {
  spaceBefore: number | null;
  spaceAfter: number | null;
  textAlign: XLIMTextAlign | null;
  textAlignLast: XLIMTextAlign | null;
  leftIndent: number | null;
  rightIndent: number | null;
  firstLineLeftIndent: number | null;
  bnDescriptor: UEditBNDescriptor | null;
  tabSettings: any | null;

  constructor(inAnother?: UEditParagraphProperties);

  inherit(inOther: UEditParagraphProperties): void;

  overrideWith(inOther: UEditParagraphProperties): void;

  duplicate(): UEditParagraphProperties;

  resetWith(inOther: UEditParagraphProperties): void;

  static Default: UEditParagraphProperties;
}


declare class XLIMTextAlign {
  static eInherit: number;
  static eStart: number;
  static eTop: number;
  static eCenter: number;
  static eEnd: number;
  static eBottom: number;
  static eJustify: number;
  static eInside: number;
  static eOutside: number;
  static eLeft: number;
  static eRight: number;
  static eTopSyn: number;
  static eBottomSyn: number;
  static eNumProperties: number;
  static eUnknown: number;

  static kTextAlignPropertyNames: string[];

  constructor(inKind: number, inTextAlign?: number);

  textAlign(inTextAlign?: number): number | void;

  isStart(): boolean;

  isCenter(): boolean;

  isEnd(): boolean;

  isJustify(): boolean;

  isInside(): boolean;

  isOutside(): boolean;

  isLeft(): boolean;

  isRight(): boolean;

  isNotEqual(inAttribute: XLIMTextAlign): boolean;
}


declare class UEditBoxView {
  $element: JQuery<HTMLElement> | null;
  $normalView: JQuery<HTMLElement> | null;
  options: any;
  parentEditor: any;
  mUEditBox: UEditBox;
  $parentViewElement: JQuery<HTMLElement> | null;
  $textFrame: JQuery<HTMLElement> | null;
  showingEmptyGraphic: boolean;
  $normalOverflowBox: JQuery<HTMLElement> | null;

  constructor(inParentEditor: any, inOptions: any);

  isInline(): boolean;

  setup(inBox: UEditBox, inJParentViewElement: JQuery<HTMLElement>): void;

  topLeftHandler(): void;

  transformationHandler(): void;

  widthHandler(inEvent: any): void;

  heightHandler(inEvent: any): void;

  backgroundColorHandler(inEvent: any): void;

  borderColorHandler(inEvent: any): void;

  borderWeightHandler(inEvent: any): void;

  updateNormalBox(): void;

  setPasteboardPosition(inLeft: number, inTop: number): boolean;

  getPositionInParentView(): { top: number; left: number } | null;

  pasteboardToParentCoordinates(inCoordinates: { left: number; top: number }): { left: number; top: number } | null;

  pasteboardToInnerCoordinates(inCoordinates: { left: number; top: number }): { left: number; top: number } | null;

  refreshViewPosition(): void;

  getBox(): UEditBox;

  remove(): void;

  detach(): void;

  after(inOtherBoxView: JQuery<HTMLElement>): void;

  before(inOtherBoxView: JQuery<HTMLElement>): void;

  appendTo(inLayerViewJElement: JQuery<HTMLElement>): void;

  getPasteboardPosition(): { top: number; left: number } | null;

  getInnerToPasteboardTransformation(): any;

  getParentPageView(): any;

  getItemWidth(): number;

  getItemHeight(): number;

  getNormalViewCSSColor(): string;

  findParentFrameBoxView(): UEditBoxView | null;

  setProperty(inPropertyName: string, inPropertyValue: any, inIgnoreLock: boolean): boolean;

  canSetProperty(inPropertyName: string, inPropertyValue: any, inIgnoreLock: boolean): boolean;

  isVisible(): boolean;

  redrawOverflowBox(): void;

  hideOverflowBox(): void;

  resetToLayerColor(): void;

  hide(): void;

  show(): void;

  hideNormalView(): void;

  showNormalView(): void;

  demoteTextFrameFromTextEdit(): void;

  promoteTextFrameToTextEdit(): void;

  getTextFrameData(): any;

  fitFrameToContent(inIgnoreLock: boolean): UEditBoxView;

  centerInFrame(inIgnoreLock: boolean): UEditBoxView;

  alignRightInFrame(inIgnoreLock: boolean): UEditBoxView;

  fitContentToFrame(inRetainProportions: boolean, inIgnoreLock: boolean): UEditBoxView;

  showEmptyGraphicOnNormalBox(): UEditBoxView;

  hideEmptyGraphicOnNormalBox(): UEditBoxView;
}


declare class UEditImageView {
  $element: JQuery;
  options: any;
  $mBoxView: any;
  parentEditor: any;
  $interimBox: JQuery;
  $imageBox: JQuery;
  $adorNormalView: JQuery;
  mImage: UEditImage;
  currentWidth: number | null;
  currentHeight: number | null;
  pauseWHEvent: boolean;
  oneIsEnough: boolean;
  realImageWidth: number;
  realImageHeight: number;
  avoidInDesignPlaceScale: boolean;

  constructor(inElement: HTMLElement, inParentEditor: any, inBoxView: any, inOptions: any);

  setup(inImage: UEditImage): void;

  backgroundColorHandler(inEvent: any): void;

  getImage(): UEditImage;

  getPasteboardPosition(): { top: number; left: number };

  getParentPageView(): any;

  getInnerToPasteboardTransformation(): any;

  getPositionInParentView(): { top: number; left: number };

  pasteboardToParentCoordinates(inCoordinates: { top: number; left: number }): { top: number; left: number };

  pasteboardToInnerCoordinates(inCoordinates: { top: number; left: number }): { top: number; left: number };

  getUnscaledImageWidth(): number;

  getUnscaledImageHeight(): number;

  getItemWidth(): number;

  getItemHeight(): number;

  getNormalViewCSSColor(): string;

  remove(): this;

  setPasteboardPosition(inLeft: number, inTop: number): boolean;

  widenTo(inWidth: number, inIgnoreLock: boolean): this;

  heightenTo(inHeight: number, inIgnoreLock: boolean): this;

  fitFrameToContent(inIgnoreLocks: boolean): this;

  centerInFrame(inIgnoreLocks: boolean): this;

  alignRightInFrame(inIgnoreLocks: boolean): this;

  fitContentToFrame(inRetainProportions: boolean, inIgnoreLocks: boolean): this;

  saveRefPointAndScaleInImage(): void;

  saveRefPointInImage(): void;

  setProperty(inPropertyName: string, inPropertyValue: any, inIgnoreLock: boolean): boolean;

  canSetProperty(inPropertyName: string, inPropertyValue: any, inIgnoreLock: boolean): boolean;

  isVisible(): boolean | null;

  static parseJHTMLNode(inParentEditor: any, inJHTMLNode: JQuery, inParentBox: any): UEditImage | null;
}


declare class UEditImage extends Events {
  parent: any;
  top: number;
  left: number;
  transformation: any;
  imageScaleTransform: any;
  imageWidth: any;
  imageHeight: any;
  backgroundColor: any;
  backgroundShade: number;
  imageURLSource: string;
  ddgData: any;
  adorName: string | null;
  fittingMode: any;
  refPoint: any;
  refPointX: number;
  refPointY: number;

  constructor(inParent: any, inAnother?: UEditImage);

  setBackgroundColor(inColor: any, inShade: number): this;

  setFittingMode(inMode: any, inRefPoint: any, inRefPointX: number, inRefPointY: number): this;

  duplicate(inParent: any): UEditImage;

  hasADOR(): boolean;

  remove(): this;

  moveBy(x: number, y: number): this;
}


declare class XLIMFittingMode {
  static eInherit: number;
  static eFitContentToFrame: number;
  static eFitFrameToContent: number;
  static eCenterInFrame: number;
  static eFitContentProportionally: number;
  static eProportionalAndCentered: number;
  static eMaintainTransformation: number;
  static eNumProperties: number;

  static eTopLeft: number;
  static eTopCenter: number;
  static eTopRight: number;
  static eCenterLeft: number;
  static eCenter: number;
  static eCenterRight: number;
  static eBottomLeft: number;
  static eBottomCenter: number;
  static eBottomRight: number;
  static eNumRefPoints: number;

  static kFittingModePropertyNames: string[];
  static kRefPointPropertyNames: string[];

  constructor(inFittingMode?: number, inRefPoint?: number, inRefPointX?: number, inRefPointY?: number);

  mode(inMode?: number): number | void;

  refPoint(inRefPoint?: number): number | void;

  refPointX(inRefPointX?: number): number | void;

  refPointY(inRefPointY?: number): number | void;

  clone(): XLIMFittingMode;

  isNotEqual(inAttribute: XLIMFittingMode): boolean;
}

declare class UEditContentObject extends Events {
  name: string;
  type: number;
  lockFlags: any;

  static eTypeText: number;
  static eTypeTextFile: number;
  static eTypeVisibility: number;
  static eTypeImage: number;
  static eTypeTable: number;
  static eTypeUnsupported: number;
  static eTypeMinimum: number;

  constructor(inName: string, inType: number, inLockFlags: any);

  watchAllOwned(): void;
}


export default class LockFlags {
  static kNone: number;
  static kX: number;
  static kY: number;
  static kLocation: number;
  static kContentLocation: number;
  static kWidth: number;
  static kHeight: number;
  static kDimension: number;
  static kRotation: number;
  static kContentRotation: number;
  static kContentDimension: number;
  static kLength: number;
  static kStrokeColor: number;
  static kStrokeWeight: number;
  static kStroke: number;
  static kBackgroundColor: number;
  static kFont: number;
  static kFontSize: number;
  static kFontStyle: number;
  static kTextColor: number;
  static kTextAlignment: number;
  static kTextAttributes: number;
  static kText: number;
  static kGraphic: number;
  static kBoxDelete: number;
  static kBoxCreate: number;
  static kPageDelete: number;
  static kPageCreate: number;
  static kPageOrder: number;
  static kAddContentObjects: number;
  static kRemoveContentObjects: number;
  static kCustomizeContentObjects: number;
  static kCustomizeContentObject: number;
  static kLayers: number;
  static kAutoLock: number;
  static kContent: number;
  static kBox: number;
  static kPage: number;
  static kTextBox: number;
  static kGraphicBox: number;
  static kLineBox: number;
  static kLayout: number;
  static kAppearance: number;
  static kDocument: number;

  static kOptionNames: { [key: string]: number };
  static kOptionValues: LockOption[];

  static initialize(): void;

  static enumerate(inLockFlags: number): string;

  static parse(inString: string): number;

  static calc(inOldLockFlags: number, inNewLockFlags: number, inMask: number): number;
}

class LockOption {
  constructor(flags: number, name: string);

  flags: number;
  name: string;
}
