package com.xuelang.spos;

import com.xuelang.spos.common.AppUtils;
import com.xuelang.spos.config.AliyunStoreOption;
import com.xuelang.spos.config.AppServiceOption;
import com.xuelang.spos.config.InitAppList;
import com.xuelang.spos.config.StreamOption;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

import java.util.HashMap;
import java.util.Map;

@SpringBootApplication
@Slf4j
public class SpOsApplication implements CommandLineRunner {
	@Autowired
	private StreamOption streamOption;
	@Autowired
	private AliyunStoreOption aliyunStoreOption;
	@Autowired
	private AppServiceOption appServiceOption;
	@Autowired
	private InitAppList initAppList;

	private static Map<String, String> parseArguments(String[] args) {
		Map<String, String> options = new HashMap<>();
		for (int i = 0; i < args.length - 1; i += 2) {
			String key = args[i].replace("--", "");
			String value = AppUtils.trimQuoteIfExist(args[i+1]);
			options.put(key, value);
		}
		return options;
	}

	public static void main(String[] args) {
		SpringApplication.run(SpOsApplication.class, args);
	}

	@Override
	public void run(String... args) throws Exception {
		Map<String, String> options = parseArguments(args);
		streamOption.buildByOptions(options);
		aliyunStoreOption.buildByOptions(options);
		appServiceOption.buildByOptions(options);
		initAppList.buildByOptions(options);
	}
}
