package com.xuelang.spos.config;


import com.xuelang.spos.oss.AliyunStoreClient;
import lombok.Data;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Data
public class AliyunStoreOption {

    private String endpoint;

    private String accessKeyId;

    private String accessKeySecret;

    private String bucketName;

    public void buildByOptions(Map<String, String> options) {
        this.endpoint = options.get("storage-oss-endpoint");
        this.accessKeyId = options.get("storage-oss-access-id");
        this.accessKeySecret = options.get("storage-oss-access-key");
        this.bucketName = options.get("storage-oss-bucket-name");
    }

    public AliyunStoreClient buildClient() {
        return new AliyunStoreClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }
}
