package com.xuelang.spos.oss.dao;

import com.xuelang.spos.config.AliyunStoreOption;
import com.xuelang.spos.oss.AliyunStoreClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class AliyunOssDao {

    @Autowired
    private AliyunStoreOption storeOption;

    public String getStringContent(String key) {
        AliyunStoreClient client = storeOption.buildClient();
        String content = client.getContent(storeOption.getBucketName(), key);
        client.destroy();
        return content;
    }

    public byte[] getBytes(String key) {
        AliyunStoreClient client = storeOption.buildClient();
        byte[] bytes = client.getByte(storeOption.getBucketName(), key);
        client.destroy();
        return bytes;
    }

    public void save(String key, String content) {
        AliyunStoreClient client = storeOption.buildClient();
        client.putContentToBucket(storeOption.getBucketName(), key, content);
        client.destroy();
    }
}
