package com.xuelang.spos.store;

import com.xuelang.spos.common.AppUtils;
import com.xuelang.spos.config.StreamOption;
import com.xuelang.spos.mq.MqClient;
import com.xuelang.spos.mq.options.Message;
import com.xuelang.spos.store.exception.DownloadDockerException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@Slf4j
public class OsStoreExceptionHandler {

    @Autowired
    private StreamOption streamOption;

    @ExceptionHandler(value = DownloadDockerException.class)
    public void handleDownloadException(Exception e) {
        log.error("handleDownloadException", AppUtils.stackTraceAsString(e));
        MqClient mqClient = streamOption.buildRedisClient();
        Message message = Message.builder()
                .queue(streamOption.getSendQueue())
                .keysAndValues(
                        Message.prepareKeysAndValues("success", "false", "msg", e.getMessage())
                )
                .build();
        mqClient.sendMessage(message);
        log.error("send error message to {}: {}", streamOption.getSendQueue(), e.getMessage());
        mqClient.destroy();
    }

}
