package com.xuelang.spos.store.data;

import com.xuelang.spos.store.exception.DownloadDockerException;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;


@Slf4j
public class DownloadRelList {

    private static List<DownloadRel> relationships = new ArrayList<>();

    public static DownloadRel queryRelByAppId(String appId) throws DownloadDockerException {
        for (DownloadRel rel: relationships) {
            if (rel.getAppId().equals(appId)) {
                return rel;
            }
        }
        String errorMessage = String.format("%s has no downloadId", appId);
        log.error(errorMessage);
        throw new DownloadDockerException(errorMessage);
    }

    public static void addRel(String appId, String downloadId) {
        DownloadRel newRel = new DownloadRel(appId, downloadId);
        int index = relationships.indexOf(newRel);
        if (index == -1) {
            relationships.add(newRel);
        } else {
            DownloadRel oldRel = relationships.get(index);
            oldRel.setAppId(newRel.getAppId());
            oldRel.setDownloadId(newRel.getDownloadId());
        }
    }
}
