package com.xuelang.spos;

import com.xuelang.spos.config.AliyunStoreOption;
import com.xuelang.spos.config.GlobalEnv;
import com.xuelang.spos.oss.exception.AddToAliyunOssException;
import com.xuelang.spos.store.data.DownloadRelList;
import com.xuelang.spos.store.service.AppActionService;
import com.xuelang.spos.store.exception.DeployDockerException;
import com.xuelang.spos.store.exception.DownloadDockerException;
import com.xuelang.spos.store.vo.ActionVo;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
public class SpOsApplicationTests {

	@Autowired
	private AppActionService appActionService;

	@Autowired
	private AliyunStoreOption aliyunStoreOption;

	@Autowired
	private GlobalEnv globalEnv;

	@Test
	public void contextLoads() {

	}

	@Test
	public void download() {
		aliyunStoreOption.setAccessKeyId("LTAItC3hB9WNO0zY");
		aliyunStoreOption.setAccessKeySecret("5c74vNrd0Jz7BbP2X7Clx8lPHTirSO");
		aliyunStoreOption.setBucketName("suanpan");
		aliyunStoreOption.setEndpoint("http://oss-cn-beijing.aliyuncs.com");

		globalEnv.setSpHost("spnext.xuelangyun.com");
		globalEnv.setSpSid("s%3ADCm-xJLwKF6kuzVdf0FSnQxgecRLiQC2.1a61l4UQdBABZdWemQwTyQAJXBo%2FDS%2B5fPHd9p6ysJs");
		globalEnv.setSpServiceDockerRegistryUrl("192.168.99.100:9876");
		globalEnv.setSpDockerRegistryHost("registry.cn-shanghai.aliyuncs.com/shuzhi");
        ActionVo vo = appActionService.download("3482");
        System.out.println(vo);
    }

	@Test
	public void downloadProgress() throws DownloadDockerException, AddToAliyunOssException {
		aliyunStoreOption.setAccessKeyId("LTAItC3hB9WNO0zY");
		aliyunStoreOption.setAccessKeySecret("5c74vNrd0Jz7BbP2X7Clx8lPHTirSO");
		aliyunStoreOption.setBucketName("suanpan");
		aliyunStoreOption.setEndpoint("http://oss-cn-beijing.aliyuncs.com");

        globalEnv.setSpHost("spnext.xuelangyun.com");
        globalEnv.setSpSid("s%3ADCm-xJLwKF6kuzVdf0FSnQxgecRLiQC2.1a61l4UQdBABZdWemQwTyQAJXBo%2FDS%2B5fPHd9p6ysJs");
        globalEnv.setSpServiceDockerRegistryUrl("192.168.99.100:9876");
        globalEnv.setSpDockerRegistryHost("registry.cn-shanghai.aliyuncs.com/shuzhi");

		DownloadRelList.addRel("3482", "c919a639-5f8c-454d-9b37-4e414d57d33b");

		ActionVo vo = appActionService.downloadProgress("3482");
		System.out.println(vo);
	}

	@Test
	public void deploy() {
        globalEnv.setSpHost("spnext.xuelangyun.com");
        globalEnv.setSpSid("s%3ADCm-xJLwKF6kuzVdf0FSnQxgecRLiQC2.1a61l4UQdBABZdWemQwTyQAJXBo%2FDS%2B5fPHd9p6ysJs");
        globalEnv.setSpServiceDockerRegistryUrl("192.168.99.100:9876");
        globalEnv.setSpDockerRegistryHost("registry.cn-shanghai.aliyuncs.com/shuzhi");

		aliyunStoreOption.setAccessKeyId("LTAItC3hB9WNO0zY");
		aliyunStoreOption.setAccessKeySecret("5c74vNrd0Jz7BbP2X7Clx8lPHTirSO");
		aliyunStoreOption.setBucketName("suanpan");
		aliyunStoreOption.setEndpoint("http://oss-cn-beijing.aliyuncs.com");
		appActionService.deploy("3482");
	}

	@Test
	public void deployProgress() throws DeployDockerException {
        globalEnv.setSpHost("spnext.xuelangyun.com");
        globalEnv.setSpSid("s%3ADCm-xJLwKF6kuzVdf0FSnQxgecRLiQC2.1a61l4UQdBABZdWemQwTyQAJXBo%2FDS%2B5fPHd9p6ysJs");
        globalEnv.setSpServiceDockerRegistryUrl("192.168.99.100:9876");
        globalEnv.setSpDockerRegistryHost("registry.cn-shanghai.aliyuncs.com/shuzhi");

		aliyunStoreOption.setAccessKeyId("LTAItC3hB9WNO0zY");
		aliyunStoreOption.setAccessKeySecret("5c74vNrd0Jz7BbP2X7Clx8lPHTirSO");
		aliyunStoreOption.setBucketName("suanpan");
		aliyunStoreOption.setEndpoint("http://oss-cn-beijing.aliyuncs.com");
		ActionVo vo = appActionService.deployStatus("3432");
		System.out.println(vo);
	}

}
