package com.xuelang.spos;

import com.xuelang.spos.config.*;
import com.xuelang.spos.mq.MqClient;
import com.xuelang.spos.mq.bussiness.LogExceptionMessageHandler;
import com.xuelang.spos.mq.bussiness.MessageRecvHandler;
import com.xuelang.spos.mq.options.Consumer;
import com.xuelang.spos.oss.service.AppInformationService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Component
@Slf4j
public class ApplicationStartup implements ApplicationListener<ApplicationReadyEvent> {

    @Autowired
    private GlobalEnv globalEnv;
    @Autowired
    private AliyunStoreOption aliyunStoreOption;
    @Autowired
    private StreamOption streamOption;
    @Autowired
    private MessageRecvHandler messageRecvHandler;
    @Autowired
    private AppInformationService appInformationService;
    @Autowired
    private AppServiceOption serviceOption;
    @Autowired
    private InitAppList initAppList;

    private void subscribeToMq() {
        MqClient mqClient = streamOption.buildRedisClient();
        Consumer consumer = Consumer.builder()
                .queue(streamOption.getRecvQueue())
                .group(streamOption.getNodeGroup())
                .name(streamOption.getNodeId())
                .delay(streamOption.getRecvQueueDelay())
                .build();
        log.info("subscribe queue: {}, group: {}, consumer: {}",
                consumer.getQueue(), consumer.getGroup(), consumer.getName());

        mqClient.subscribeQueue(
                consumer,
                this.messageRecvHandler,
                new LogExceptionMessageHandler()
        );
    }

    @Override
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        loggingInputOptions();

        boolean forceUpdate = serviceOption.isForceUpdate();
        appInformationService.sync(forceUpdate, initAppList.getContent());
        log.info("app data synced to aliyun oss, force is {}", forceUpdate);

        ExecutorService executorService = Executors.newFixedThreadPool(3);
        Future future = executorService.submit(this::subscribeToMq);
        try {
            future.get();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        executorService.shutdown();
    }

    private void loggingInputOptions() {
        log.info("Running spos-backend with following options");
        log.info("globalEnv: {}", globalEnv);
        log.info("aliyunStoreOption: {}", aliyunStoreOption);
        log.info("streamOption: {}", streamOption);
    }
}
