package com.xuelang.spos.config;

import lombok.Data;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Data
public class AppServiceOption {

    private String userId;

    private String appId;

    private boolean forceUpdate;

    public void buildByOptions(Map<String, String> options) {
        this.userId = options.get("stream-user-id");
        this.appId = options.get("stream-app-id");
        this.forceUpdate = Boolean.parseBoolean(options.get("force-update"));
    }
}
