package com.xuelang.spos.config;

import lombok.Data;
import lombok.Getter;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;


@Component
@Data
public class GlobalEnv {
    private String spHost;

    private String spSid;

    private String spDockerRegistryHost;

    private String spServiceDockerRegistryUrl;

    @PostConstruct
    public void init() {
        this.spHost = System.getenv("SP_HOST");
        this.spSid = System.getenv("SP_SID");
        this.spDockerRegistryHost = System.getenv("SP_DOCKER_REGISTRY_HOST");
        this.spServiceDockerRegistryUrl = System.getenv("SP_SERVICE_DOCKER_REGISTRY_URL");
    }

    @Override
    public String toString() {
        return "GlobalEnv{" +
                "spHost='" + spHost + '\'' +
                ", spSid='" + spSid + '\'' +
                ", spDockerRegistryHost='" + spDockerRegistryHost + '\'' +
                ", spServiceDockerRegistryUrl='" + spServiceDockerRegistryUrl + '\'' +
                '}';
    }
}
