package com.xuelang.spos.mq.bussiness;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xuelang.spos.mq.MqEventType;
import com.xuelang.spos.mq.constant.InputAppList;
import com.xuelang.spos.mq.dto.MqEventDto;
import com.xuelang.spos.mq.handler.XReadGroupHandler;
import com.xuelang.spos.mq.response.XReadGroupResponse;
import com.xuelang.spos.mq.service.MqService;
import com.xuelang.spos.oss.bo.AppBo;
import com.xuelang.spos.oss.service.AppInformationService;
import com.xuelang.spos.store.service.AppActionService;
import com.xuelang.spos.store.vo.ActionVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Slf4j
@Component
public class MessageRecvHandler implements XReadGroupHandler {

    @Autowired
    private AppInformationService appInformationService;
    @Autowired
    private AppActionService appActionService;
    @Autowired
    private MqService mqService;

    private MqEventDto extractInput(XReadGroupResponse response, String inputNum) {
        MqEventDto eventDto = new MqEventDto();
        List<Map<String, String>> data = response.getData();
        for (Map<String, String> item: data) {
            if (item.containsKey(inputNum)) {
                String value = item.get(inputNum);
                JSONObject parseObject = JSON.parseObject(value);
                String event = parseObject.getString("event");
                JSONObject eventData = parseObject.getJSONObject("data");
                eventDto.setEvent(event);
                eventDto.setData(eventData);
                eventDto.setFrom(inputNum);
                return eventDto;
            }
        }
        return eventDto;
    }

    private String queryId(MqEventDto eventDto) {
        return eventDto.getData().getString("id");
    }

    private JSONObject prepareOutputData(String event, Object object) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(event, JSON.toJSONString(object));
        return jsonObject;
    }

    private void dispatchEvent(MqEventDto eventDto) {
        log.info("dispatchEvent: {}", eventDto);

        String target = eventDto.getFrom().replace("in", "out");
        List<String> targets = InputAppList.apps.stream()
                .map(app -> app.replace("in", "out"))
                .collect(Collectors.toList());
        try {
            switch (eventDto.getEvent()) {
                case MqEventType.QUERY_APP: {
                    List<AppBo> appBos = appInformationService.queryAll();
                    mqService.sendSuccessMessageToTarget(
                            target,
                            prepareOutputData(eventDto.getEvent(), appBos)
                    );
                    break;
                }
                case MqEventType.DOWNLOAD_APP: {
                    ActionVo vo = appActionService.download(queryId(eventDto));
                    mqService.sendSuccessMessageToTarget(
                            targets,
                            prepareOutputData(eventDto.getEvent(), vo)
                    );
                    break;
                }
                case MqEventType.QUERY_DOWNLOAD_PROGRESS: {
                    ActionVo vo = appActionService.downloadProgress(queryId(eventDto));
                    mqService.sendSuccessMessageToTarget(
                            target,
                            prepareOutputData(eventDto.getEvent(), vo)
                    );
                    break;
                }
                case MqEventType.DEPLOY_APP: {
                    ActionVo vo = appActionService.deploy(queryId(eventDto));
                    mqService.sendSuccessMessageToTarget(
                            target,
                            prepareOutputData(
                                    eventDto.getEvent(),
                                    vo
                            )
                    );
                    break;
                }
                case MqEventType.QUERY_DEPLOY_PROGRESS: {
                    ActionVo vo = appActionService.deployStatus(queryId(eventDto));
                    mqService.sendSuccessMessageToTarget(
                            target,
                            prepareOutputData(eventDto.getEvent(), vo)
                    );
                    break;
                }
                case MqEventType.UNINSTALL_APP: {
                    ActionVo vo = appActionService.uninstall(queryId(eventDto));
                    mqService.sendSuccessMessageToTarget(
                            target,
                            prepareOutputData(eventDto.getEvent(), vo)
                    );
                    break;
                }
            }
        } catch (Exception e) {
            log.error("dispatchEvent {} failed", eventDto.getEvent());
            mqService.sendErrorMessageToTarget(
                    InputAppList.apps,
                    "exception threw for " + eventDto.getEvent()
            );
        }
    }

    @Override
    public void handle(XReadGroupResponse response) {
        log.info("receive: {}", response);
        InputAppList.apps.forEach(appInput -> {
            MqEventDto eventDto = extractInput(response, appInput);
            if (!eventDto.getEvent().equals(MqEventDto.EMPTY_EVENT)) {
                dispatchEvent(eventDto);
            }
        });
    }
}
