package com.xuelang.spos.mq.service;

import com.alibaba.fastjson.JSONObject;
import com.xuelang.spos.config.StreamOption;
import com.xuelang.spos.mq.MqClient;
import com.xuelang.spos.mq.options.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Service
@Slf4j
public class RedisMqService implements MqService {

    @Autowired
    private StreamOption streamOption;

    @Override
    public void sendSuccessMessageToTarget(String target, JSONObject output) {
        List<String> targets = Collections.singletonList(target);
        sendSuccessMessageToTarget(targets, output);
    }

    @Override
    public void sendSuccessMessageToTarget(List<String> targets, JSONObject output) {
        MqClient client = streamOption.buildRedisClient();
        Message message = buildSuccessMessage(targets, output);
        client.sendMessage(message);
        log.info("send message to {}, output: {}", targets, output);
        client.destroy();
    }

    @Override
    public void sendErrorMessageToTarget(List<String> targets, String errorMessage) {
        MqClient client = streamOption.buildRedisClient();
        Message message = Message.builder()
                .queue(streamOption.getSendQueue())
                .keysAndValues(Message.prepareKeysAndValues(
                        "node_id",
                        streamOption.getNodeId(),
                        "success", "false",
                        "msg", errorMessage)
                )
                .build();
        client.sendMessage(message);
        client.destroy();
    }

    private Message buildSuccessMessage(List<String> targets, JSONObject data) {
        Message message = Message.builder()
                .queue(streamOption.getSendQueue())
                .build();
        List<String> keysAndValues = new ArrayList<>();
        keysAndValues.addAll(Arrays.asList(
            "node_id", streamOption.getNodeId(),
            "success", "true"
        ));
        targets.forEach(target -> {
            keysAndValues.add(target);
            keysAndValues.add(data.toJSONString());
        });
        message.setKeysAndValues(keysAndValues.toArray(new String[0]));
        return message;
    }
}
