package com.xuelang.spos.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import org.apache.commons.io.IOUtils;

import java.io.*;
import java.nio.charset.StandardCharsets;

public class AliyunStoreClient {

    private OSSClient ossClient;

    public AliyunStoreClient(String getEndpoint, String getAccessKeyId, String getAccessKeySecret) {
        this.ossClient = new OSSClient(
                getEndpoint,
                getAccessKeyId,
                getAccessKeySecret
        );
    }

    public void putContentToBucket(String bucketName, String key, String content) {
        this.ossClient.putObject(bucketName, key, new ByteArrayInputStream(content.getBytes()));
    }

    public String getContent(String bucketName, String key) {
        OSSObject ossObject = this.ossClient.getObject(bucketName, key);
        try {
            InputStream inputStream = ossObject.getObjectContent();
            String content = IOUtils.toString(inputStream, StandardCharsets.UTF_8);
            ossObject.close();
            return content;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getByte(String bucketName, String key) {
        OSSObject ossObject = this.ossClient.getObject(bucketName, key);
        try {
            InputStream inputStream = ossObject.getObjectContent();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024 * 4];
            int n;
            while (-1 != (n = inputStream.read(buffer))) {
                output.write(buffer, 0, n);
            }
            ossObject.close();
            return output.toByteArray();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
        this.ossClient.shutdown();
    }
}
