package com.xuelang.spos.oss.bo;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Data
public class AppBo {
    private Long id;
    private String name;
    private String version;
    private String description;
    private List<String> icons = new ArrayList<>();
    private String type;
    private String spid;
    private Map splashScreen;
    private String homeUrl;
    private String widgetUrl;
    private List<String> permissions = new ArrayList<>();
    private String status;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AppBo appBo = (AppBo) o;
        return id.equals(appBo.id) &&
                spid.equals(appBo.spid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, spid);
    }
}
