package com.xuelang.spos.oss.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.xuelang.spos.config.AppServiceOption;
import com.xuelang.spos.oss.bo.AppBo;
import com.xuelang.spos.oss.constant.AppStatus;
import com.xuelang.spos.oss.dao.AliyunOssDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AppInformationServiceImpl implements AppInformationService {

    @Autowired
    private AppServiceOption serviceOption;

    @Autowired
    private AliyunOssDao dao;

    private String dataKey() {
        return String.format("studio/%s/%s/data/app.json", serviceOption.getUserId(), serviceOption.getAppId());
    }

    @Override
    public void sync(boolean force, String content) {
        if (force) {
            dao.save(dataKey(), content);
        }
    }

    @Override
    public List<AppBo> queryAll() {
        String content = dao.getStringContent(dataKey());
        List<AppBo> appBos = JSON.parseObject(content, new TypeReference<List<AppBo>>() {});
        return appBos;
    }

    @Override
    public void updateAppStatus(String spid, AppStatus status) {
        List<AppBo> appBos = queryAll();
        appBos.forEach(app -> {
            if (app.getSpid().equals(spid)) {
                app.setStatus(status.getStatus());
            }
        });
        dao.save(dataKey(), JSON.toJSONString(appBos));
    }
}
