-- You must run this from "0.sql" on the parent directory.
-- The general mechanisms of "ysqlsh" and "psql" lack useful notions
-- that correspond to "\ir" for "\o" and for the file arhuments for "\copy".

\ir cr-to_char-interval.sql
\ir cr-jan-and-jul-tz-abbrevs-and-offsets.sql
\ir copy-from-tz-database.sql
\ir cr-tz-database-time-zones-extended.sql
\ir cr-extended-timezone-names.sql
\ir cr-extended-timezone-names-column-paddings.sql

-- These views:
--   "canonical_no_country_no_dst"
--   "canonical_real_country_no_dst"
--   "canonical_real_country_with_dst"
-- assume that that following 'assert' holds.
-- It ought, to by construction. See "cr-extended-timezone-names.sql".
do $body$
declare
  c int not null := 0;
begin
  select count(*) from extended_timezone_names
  where not utc_offset in (std_offset, dst_offset)
  into c;
  assert c = 0, 'assert failed';
end;
$body$;

\ir cr-canonical-no-country-no-dst.sql
\ir cr-canonical-real-country-no-dst.sql
\ir cr-canonical-real-country-with-dst.sql

\ir extended-timezone-names-to-plain-text/unrestricted-full-projection.sql
\ir extended-timezone-names-to-plain-text/canonical-no-country-no-dst.sql
\ir extended-timezone-names-to-plain-text/canonical-real-country-with-dst.sql
\ir extended-timezone-names-to-plain-text/canonical-real-country-no-dst.sql

\ir extended-timezone-names-to-md-table/unrestricted-full-projection.sql
\ir extended-timezone-names-to-md-table/canonical-real-country-with-dst.sql
\ir extended-timezone-names-to-md-table/canonical-real-country-no-dst.sql
\ir extended-timezone-names-to-md-table/canonical-no-country-no-dst.sql

\ir do-QA-reports.sql
\ir drop-temporary-objects.sql    
