/*
https://en.wikipedia.org/wiki/List_of_tz_database_time_zones

Country code
Latitude, longitude ±DDMM(SS)±DDDMM(SS)
TZ database name
Portion of country covered
Status
UTC offset ±hh:mm
UTC DST offset ±hh:mm
Notes
*/;
--------------------------------------------------------------------------------

drop table if exists tz_database_time_zones_stage cascade;
create table tz_database_time_zones_stage(
  k                serial not null,
  country_code     text,
  lat_long         text,
  name             text primary key,
  region_coverage  text,
  status           text not null,
  std_offset       text,
  dst_offset       text,
  notes            text
  );

alter sequence tz_database_time_zones_stage_k_seq minvalue 0 restart with 0;

-- Notice the path to the "copy-from" file.
-- This script can be invoked only from is parent directory.
\copy tz_database_time_zones_stage(country_code, lat_long, name, region_coverage, status, std_offset, dst_offset, notes) from extended-timezone-names/tz-database-timezone-names.txt with (format 'text');

-- The DELIMITER default is a <tab> character in 'TEXT' format.
-- HEADER option allowed TRUE only for 'CSV' format.
-- So delete the first row (with "k = 0") immediately after ingest.
delete from tz_database_time_zones_stage where k = 0;

-- The original data (scraped from the browser view of the page using "Edge" on MSFT Windows 10)
-- uses ascii code 8722 and not the plain "-" (ascii code 45).
-- This causes no end of problems. For example, what looks like '-03:00' cannot be typecast to interval!
-- ERROR:  invalid input syntax for type interval: "−03:00".
drop view if exists tz_database_time_zones_view cascade;
create view tz_database_time_zones_view as
select
  name,
  replace(t.std_offset, chr(8722), '-')::interval as std_offset, -- LOOK !
  replace(t.dst_offset, chr(8722), '-')::interval as dst_offset, -- LOOK !
  country_code,
  replace(t.lat_long, chr(8722), '-') as lat_long,               -- LOOK !
  region_coverage,
  status
from tz_database_time_zones_stage as t;
