-- Start report name with PG- or YB-
\o extended-timezone-names/YB-QA-reports.txt

\t on
select '--------------------------------------------------------------------------------------------------------------';
select 'Establish that it''s reasonable to join "pg_timezone_names" with "tz_database_time_zones_view".';
\t off

select name as "in 'tz_database_time_zones_view' but not in 'pg_timezone_names'"
from tz_database_time_zones_view
where name not in (select name from pg_timezone_names)
order by 1;

select name as "in 'pg_timezone_names' but not in 'tz_database_time_zones_view'"
from pg_timezone_names
where name not in (select name from tz_database_time_zones_view)
order by 1;

\t on
select '--------------------------------------------------------------------------------------------------------------';
select 'is utc_offset one of (std_offset, dst_offset) from tz_database_time_zones_view?';
\t off

-- The definition of the tz_database_time_zones_extended_raw uses a restriction
-- that will eliminate any these rows that this finds.
with v as (
  select
    p.name,
    p.utc_offset,
    t.std_offset,
    t.dst_offset
  from
    pg_timezone_names as p
    inner join
    tz_database_time_zones_view as t using (name))
select name, utc_offset, std_offset, dst_offset
from v
where utc_offset not in (std_offset, dst_offset)
order by name;


\t on
select '--------------------------------------------------------------------------------------------------------------';
select 'What rows have "std_offset" and "dst_offset" back-to-front in "List of tz database time zones"?';
\t off

-- There are some rows that are bad in this way.
-- This can only be a bug on the "List of tz database time zones" Wikipedia page:
-- en.wikipedia.org/wiki/List_of_tz_database_time_zones.
-- See "Fix the bug from the "List of tz database time zones" in "cr-tz-database-time-zones-extended.sql".

select name, std_offset, dst_offset
from tz_database_time_zones_view as t
where t.std_offset > t.dst_offset
order by name;


\t on
select '--------------------------------------------------------------------------------------------------------------';
select 'What rows were eliminated because of disagreement on utc_offset values?';
\t off

-- The rows are eliminated 'cos of disagreement between pg_timezone_names AND tz_database_time_zones_extended_raw.
-- See e.g. "Daylight saving time in Morocco"
--   en.wikipedia.org/wiki/Daylight_saving_time_in_Morocco
-- "As of 2018, daylight saving time (DST) is permanently observed in Morocco.

select
  (select count(*) from tz_database_time_zones_extended_raw)  as "raw count",
  (select count(*) from tz_database_time_zones_extended)      as "good count",
  (select count(*) from bad_names)                            as "bad count";

select
  name,
  lpad(jan_offset::text, 9) as "JAN offset",
  lpad(jul_offset::text, 9) as "JUL offset",
  lpad(std_offset::text, 9) as "STD offset",
  lpad(dst_offset::text, 9) as "DST offset"  
from tz_database_time_zones_extended_raw
where name in (
  select b.name from bad_names b)
order by name;


\t on
select '--------------------------------------------------------------------------------------------------------------';
select 'Basic test of "extended_timezone_names"';

\x on
select
  name,
  abbrev,
  std_abbrev,
  dst_abbrev,
  to_char_interval(utc_offset) as utc_offset,
  to_char_interval(std_offset) as std_offset,
  to_char_interval(dst_offset) as dst_offset,
  is_dst::text,
  country_code,
  lat_long,
  region_coverage,
  status
from extended_timezone_names
where name in ('America/Los_Angeles', 'Asia/Manila', 'Europe/London')
order by name;
\x off
\t off

\o
