drop procedure if exists assert_approved_timezone_name(text) cascade;

create procedure assert_approved_timezone_name(tz in text)
  language plpgsql
as $body$
declare
  bad constant boolean not null :=
    (select count(*) from approved_timezone_names where lower(name) = lower(tz)) <> 1;
begin
  if bad then
    declare
      code  constant text not null := '22023';
      msg   constant text not null := 'Invalid value for parameter TimeZone "'||tz||'"';
      hint  constant text not null := 'Use a name that''s found exactly once in "approved_timezone_names"';
    begin
      raise exception using
        errcode = code,
        message = msg,
        hint    = hint;
    end;
  end if;
end;
$body$;

drop procedure if exists test_assert_approved_timezone_name(text) cascade;
create procedure test_assert_approved_timezone_name(tz in text)
  language plpgsql
as $body$
begin
  call assert_approved_timezone_name(tz);
  assert false, 'Call test_assert_approved_timezone_name() only with a non-approved timezone name.';
exception when invalid_parameter_value then
  null;
end;
$body$;

-- "Iceland" is listed in "pg_timezone_names".
-- but the List of tz database time zones (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones)
-- has it with status = 'Deprecated',
call test_assert_approved_timezone_name('Iceland');
drop procedure if exists test_assert_approved_timezone_name(text) cascade;
