-- plain timestamp in, timestamptz out.
drop function if exists at_timezone(text, timestamp) cascade;

create function at_timezone(tz in text, t in timestamp)
  returns timestamptz
  language plpgsql
as $body$
begin
  call assert_approved_timezone_name(tz);
  return timezone(tz, t);
end;
$body$;

-- This overload is almost textually identical to the preceding one.
-- The data types of the second formal and the return have
-- simply been exchanged.
-- timestamptz in, plain timestamp out.
drop function if exists at_timezone(text, timestamptz) cascade;

create function at_timezone(tz in text, t in timestamptz)
  returns timestamp
  language plpgsql
as $body$
begin
  call assert_approved_timezone_name(tz);
  return timezone(tz, t);
end;
$body$;

-- interval in, timestamptz out.
drop function if exists at_timezone(interval, timestamp) cascade;

create function at_timezone(i in interval, t in timestamp)
  returns timestamptz
  language plpgsql
as $body$
begin
  call assert_acceptable_timezone_interval(i);
  return timezone(i, t);
end;
$body$;

-- This overload is almost textually identical to the preceding one.
-- The data types of the second formal and the return have
-- simply been exchanged.
-- interval in, plain timestamp out.
drop function if exists at_timezone(interval, timestamptz) cascade;

create function at_timezone(i in interval, t in timestamptz)
  returns timestamp
  language plpgsql
as $body$
begin
  call assert_acceptable_timezone_interval(i);
  return timezone(i, t);
end;
$body$;
