-- There's no \or (relative spool) metacommand.
-- So when this file is invoked by "0.sql" on its parent directory,
-- the spool file path must be given relative to that parent parent directory.

\o extended-timezone-names/extended-timezone-names-to-plain-text/spool/unrestricted-full-projection.txt
select
  name,
  abbrev,
  std_abbrev,
  dst_abbrev,
  lpad(to_char_interval(utc_offset), 6) as "UTC offset",
  lpad(to_char_interval(std_offset), 6) as "STD offset",
  lpad(to_char_interval(dst_offset), 6) as "DST offset",
  is_dst::text,
  country_code,
  lat_long,
  region_coverage,
  status
from extended_timezone_names
order by utc_offset, name;
\o
