drop procedure if exists set_timezone(text) cascade;

create procedure set_timezone(tz in text)
  language plpgsql
as $body$
begin
  call assert_approved_timezone_name(tz);
  declare
    stmt constant text not null := 'set timezone = '''||tz||'''';
  begin
    execute stmt;
  end;
end;
$body$;


drop procedure if exists set_timezone(interval) cascade;

create procedure set_timezone(i in interval)
  language plpgsql
as $body$
begin
  call assert_acceptable_timezone_interval(i);
  declare
    stmt constant text not null := 'set time zone interval '''||i::text||'''';
  begin
    execute stmt;
  end;
end;
$body$;
