-- First, set up with this:

\ir 01-cr-tables.sql
\ir 02-cr-edges-table-and-proc.sql
\ir 03-insert-synthetic-data.sql
\ir 04-populate-edges-table-and-check-contents.sql
\ir 05-cr-raw-paths-table.sql
\ir 06-cr-list-paths.sql
\ir 07-find-paths-naive.sql
\ir 08-cr-raw-paths-with-tracing.sql
\ir 09-find-paths-no-pruning.sql

-- Then...

delete from temp_paths;
insert into temp_paths(path)
select path from raw_paths where cardinality(path) = 4;
delete from raw_paths where cardinality(path) >= 4;

-- Tidy up to give where we'd be at this point WITH pruning
-- Prune all but one path to each distinct new terminal.
delete from raw_paths
where
(
  path not in (select min(path) from raw_paths group by terminal(path)) and
  terminal(path) in (select terminal(path) from raw_paths)
);

drop function if exists blank_lines(int) cascade;
create function blank_lines(lines in int)
  returns table(z text)
  language plpgsql
as $body$
begin
  for j in 1..lines loop
    z := ''; return next;
  end loop;
end;
$body$;

\t on
select blank_lines(50);
select '--------------------------------------------------------------------------------';
select 'DEMO STARTS.';

select '"raw_paths" to date after one rep. of the recursive term.';
select path from raw_paths order by path[1], path[2], path[3], path[4];

select '"temp_paths" produced by the second rep. of the recursive term before pruning.';
select path from temp_paths order by path[1], path[2], path[3], path[4];

-- Prune all but one path to each distinct new terminal.
delete from temp_paths
where
(
  path not in (select min(path) from temp_paths group by terminal(path))
);

select '"temp_paths" after pruning all but one path to each distinct new terminal.';
select path from temp_paths order by path[1], path[2], path[3], path[4];

-- Prune newer (and therefore longer) paths to
-- already-found terminals.
delete from temp_paths
where
(
  terminal(path) in
  (
    select terminal(path)
    from raw_paths
  )
);

select '"temp_paths" after pruning newer (and therefore longer) paths to already-found terminals.';
select path from temp_paths order by path[1], path[2], path[3], path[4];
select 'Nothing survives. So the (so-called) recursion stops.';
\t off
