drop function if exists unix_tree() cascade;

create function unix_tree()
  returns table(t text)
  language plpgsql
as $body$
<<b>>declare
  results text[] not null := '{}';
begin
  with
    a1 as (
      select
        cardinality(path) as depth,
        path
      from top_down_paths),

    a2 as (
      select
        depth,
        lead(depth, 1, 99) over w as next_depth,
        path
      from a1
      window w as (
        order by
          path[2] asc nulls first,
          path[3] asc nulls first,
          path[4] asc nulls first,
          path[5] asc nulls first)),

    results as (
      select
        case depth = next_depth
          when true then
            lpad(' ├── ', (depth - 1)*5, ' ')
          else
            lpad(' └── ', (depth - 1)*5, ' ')
        end
        ||
        path[depth] as result
      from a2
      order by
        path[2] asc nulls first,
        path[3] asc nulls first,
        path[4] asc nulls first,
        path[5] asc nulls first)

  select array_agg(r.result)
  into b.results
  from results as r;

  foreach t in array results loop
    -- Implement the logic to transform the present results
    -- into the Unix "tree" format by adding vertical bars
    -- as approapriate.
  end loop;

  foreach t in array results loop
    return next;
  end loop;
end b;
$body$;

select t from unix_tree();
