drop view if exists top_down_paths cascade;
create view top_down_paths(path) as
with
  recursive paths(path) as (
    select array[name]
    from emps
    where mgr_name is null

    union all

    select p.path||e.name
    from emps as e
    inner join paths as p on e.mgr_name = p.path[cardinality(path)] 
  )
select path from paths;
