do $body$
declare
  c constant int not null :=
    (
      with
        a1(depth, mgr_name, name) as (
          select depth, mgr_name, name from top_down_simple),

        a2(depth, mgr_name, name) as (
          select
            cardinality(path),
            case cardinality(path)
              when 1 then '-'
              else        path[cardinality(path) - 1]
            end,
            path[cardinality(path)]
          from top_down_paths),

        a1_except_a2(depth, mgr_name, name) as (
          select depth, mgr_name, name from a1
          except
          select depth, mgr_name, name from a2),

        a2_except_a1(depth, mgr_name, name) as (
          select depth, mgr_name, name from a2
          except
          select depth, mgr_name, name from a1)

      select count(*) from
      (
        select depth, mgr_name, name from a1_except_a2
        union all
        select depth, mgr_name, name from a2_except_a1
      ) as n
    );
begin
 assert c = 0, 'Unexpected';
end;
$body$;
