delete from edges; 
alter table edges drop constraint if exists edges_chk cascade;
alter table edges add constraint edges_chk check(node_1 <> node_2);

insert into edges(node_1, node_2) values
  ('n1', 'n2'),
  ('n2', 'n3'),
  ('n2', 'n4'),
  ('n3', 'n5'),
  ('n4', 'n5'),
  ('n4', 'n6'),
  ('n5', 'n6');
  
-- Implement the denormalization.
insert into edges(node_1, node_2)
select node_2 as node_1, node_1 as node_2
from edges;

\ir ../../2-find-paths-implementations/cr-find-paths-with-nocycle-check.sql
call find_paths(start_node => 'n1');
call restrict_to_shortest_paths('raw_paths', 'shortest_paths');

\ir ../../2-find-paths-implementations/cr-find-paths-with-pruning.sql
call find_paths(start_node => 'n1', prune => true);

call assert_shortest_paths_same_as_raw_paths();

