delete from edges;
alter table edges drop constraint if exists edges_chk cascade;
alter table edges add constraint edges_chk check(node_1 <> node_2);

insert into edges(node_1, node_2) values
  ('n01', 'n02'),
  ('n02', 'n03'),
  ('n03', 'n04'),
  ('n04', 'n05'),
  ('n05', 'n06'),
  ('n06', 'n07'),
  ('n07', 'n08'),

  ('n01', 'n09'),
  ('n09', 'n05'),
  ('n05', 'n10'),
  ('n10', 'n08');

-- Implement the denormalization.
insert into edges(node_1, node_2)
select node_2 as node_1, node_1 as node_2
from edges;

\ir ../../2-find-paths-implementations/cr-find-paths-with-nocycle-check.sql

call find_paths(start_node => 'n01');

\o 6-results/5-demo-unq_containing-paths.txt
\t on

call restrict_to_shortest_paths('raw_paths', 'temp_paths');
call restrict_to_unq_containing_paths('temp_paths', 'unq_containing_paths');
select 'unq_containing_paths of shortest_paths of raw_paths';
select t from list_paths('unq_containing_paths');

call restrict_to_unq_containing_paths('raw_paths', 'temp_paths');
call restrict_to_longest_paths('temp_paths', 'unq_containing_paths');
select 'longest_paths of unq_containing_paths of raw_paths';
select t from list_paths('unq_containing_paths');

\t off
\o
