\ir ../../2-find-paths-implementations/cr-find-paths-with-nocycle-check.sql

delete from edges;
alter table edges drop constraint if exists edges_chk cascade;
alter table edges add constraint edges_chk check(node_1 <> node_2);

insert into edges(node_1, node_2) values
  ('n2', 'n1'),
  ('n2', 'n4'),
  ('n4', 'n5'),
  ('n4', 'n6'),
  ('n6', 'n4'),
  ('n5', 'n6'),
  ('n5', 'n3'),
  ('n3', 'n2');

call find_paths(start_node => 'n2');
call restrict_to_shortest_paths('raw_paths', 'shortest_paths');

\o 6-results/2-directed-cyclic-graph.txt
\t on
select t from list_paths('raw_paths');
select t from list_paths('shortest_paths');
\t off
\o
