\ir ../../2-find-paths-implementations/cr-find-paths-with-nocycle-check.sql

delete from edges;
alter table edges drop constraint if exists edges_chk cascade;
alter table edges add constraint edges_chk check(node_1 <> node_2);

insert into edges(node_1, node_2) values
  ('n01', 'n02'),
  ('n01', 'n03'),
  ('n01', 'n04'),
  ('n02', 'n05'),
  ('n02', 'n06'),
  ('n05', 'n11'),
  ('n05', 'n12'),
  ('n03', 'n07'),
  ('n03', 'n08'),
  ('n04', 'n09'),
  ('n04', 'n10'),
  ('n10', 'n13'),
  ('n10', 'n14');

-- The root is uniquely defined, so it can be determined mechanically.
do $body$
declare
  root constant text not null := (
    select distinct node_1 from edges
    where node_1 not in (
      select node_2 from edges)
  );
begin
  call find_paths(start_node => root);
end;
$body$;

\o 6-results/4-rooted-tree.txt
\t on
select t from list_paths('raw_paths');
\t off
\o

call restrict_to_shortest_paths('raw_paths', 'shortest_paths');
call assert_shortest_paths_same_as_raw_paths();
