call find_paths('Emily', false);

\t off
select count(*) as "total number of paths" from raw_paths;
select repeat_nr, count(*) as number_of_paths
from raw_paths
group by repeat_nr
order by 1;

\t on
call restrict_to_shortest_paths('raw_paths', 'shortest_paths');
select t from list_paths('shortest_paths');

call find_paths('Emily', true);
call assert_shortest_paths_same_as_raw_paths();

call restrict_to_unq_containing_paths('shortest_paths', 'unq_containing_paths');
select t from list_paths('unq_containing_paths');

select 'All decorated shortest paths';
select t from decorated_paths_report('shortest_paths');

select 'Decorated shortest path to Helen';
select t from decorated_paths_report('shortest_paths', 'Helen');
\t off
