drop table if exists emps cascade;
create table emps(
  name     text primary key,
  mgr_name text);

-- The order of insertion is arbitrary
insert into emps(name, mgr_name) values
  ('mary',   null),
  ('fred',  'mary'),
  ('susan', 'mary'),
  ('john',  'mary'),
  ('doris', 'fred'),
  ('alice', 'john'),
  ('bill',  'john'),
  ('joan',  'bill'),
  ('george', 'mary'),
  ('edgar', 'john'),
  ('alfie', 'fred'),
  ('dick',  'fred');

-- Implement the one-to-many "pig's ear".
alter table emps
add constraint emps_mgr_name_fk
foreign key(mgr_name) references emps(name)
on delete restrict;

-- The ultimate manager has no manager.
-- Enforce the business rule "Maximum one ultimate manager".
create unique index t_mgr_name on emps((mgr_name is null)) where mgr_name is null;
