drop function if exists other_node(text, text, text) cascade;

create function other_node(this_node in text, node_1 in text, node_2 in text)
  returns text
  language plpgsql
as $body$
begin
  -- Will get "case not found" error if no match.
  case
    when this_node = node_1 then return node_2;
    when this_node = node_2 then return node_1;
  end case;
end;
$body$;

drop procedure if exists find_paths(text) cascade;

create procedure find_paths(start_node in text)
  language plpgsql
as $body$
begin
  -- See "cr-find-paths-with-pruning.sql". This index demonstrates that
  -- no more than one path has been found to any particular terminal node.
  drop index if exists raw_paths_terminal_unq cascade;
  commit;

  -- More efficient to insert all the rows and THEN create the index.
  -- Only a single sesion accesses "raw_paths" concurrenty.
  drop index if exists raw_paths_path_unq cascade;
  commit;

  delete from raw_paths;

  with
    recursive paths(path) as (
      select array[start_node, other_node(start_node, node_1, node_2)]
      from edges where node_1 = start_node or node_2 = start_node

      union all

      select p.path||other_node(terminal(p.path), e.node_1, e.node_2)
      from edges e, paths p
      where (e.node_1 = terminal(p.path) or e.node_2 = terminal(p.path))
      and not other_node(terminal(p.path), e.node_1, e.node_2) = any(p.path) -- <<<<< Prevent cycles.
      )
  insert into raw_paths(path)
  select path
  from paths;

  create unique index raw_paths_path_unq on raw_paths(path_as_text(path));
  commit;
end;
$body$;
