\ir ../../2-find-paths-implementations/cr-find-paths-with-pruning.sql

delete from edges;
alter table edges drop constraint if exists edges_chk cascade;
alter table edges add constraint edges_chk check(node_1 <> node_2);

insert into edges(node_1, node_2) values
  ('n1', 'n2'),
  ('n2', 'n3'),
  ('n2', 'n4'),
  ('n3', 'n5'),
  ('n4', 'n5'),
  ('n4', 'n6'),
  ('n5', 'n6');

-- Implement the denormalization.
insert into edges(node_1, node_2)
select node_2 as node_1, node_1 as node_2
from edges;

call find_paths(start_node => 'n1', prune => true);
delete from shortest_paths;
insert into shortest_paths(k, path) select k, path from raw_paths;

\o 6-results/1-pruned-paths.txt
\t on
select t from list_paths('raw_paths');
select t from list_paths('shortest_paths');
\t off

do $body$
declare
  node text not null := '';
begin
  for node in (
    select distinct node_1 from edges
    where node_1 <> 'n1')
  loop
    call find_paths(start_node => node, prune => true);
    insert into shortest_paths(k, path) select k, path from raw_paths;
  end loop;
end;
$body$;

\t on
select t from list_paths('shortest_paths');
\t off
\o
