-- Annoyingly, there's no relative variant of the "\o" metacommand
-- analogously to how "\ir" is the relative variant of the "\i" metacommand.
-- So this script works as intended only when it's
-- invoked from the parent directory.
--------------------------------------------------------------------------------

delete from edges;
call populate_maximum_connectvity_edges(nr_nodes=>:nr_nodes);

-- Implement the denormalization.
insert into edges(node_1, node_2)
select node_2 as node_1, node_1 as node_2
from edges;

\t on

\o 5-stress-test/start_spooling.sql
select start_spooling_script(:nr_nodes, :method);
\o

\ir start_spooling.sql
select :method||' -- '||ltrim(:nr_nodes::text)||' nodes';
call start_stopwatch();
call invoke_find_paths(:method);
select 'elapsed time: '||stopwatch_reading() as t;
select 'count(*) from raw_paths: '||ltrim(to_char(count(*), '999,999,999,999')) from raw_paths;
\o

\t off
