drop function if exists powers_of_two(int) cascade;

create function powers_of_two(stop in int)
  returns table(t text)
  language plpgsql
as $body$
declare
  r numeric not null := 1;
begin
  for j in 1..stop loop
    r := 2^j;
    t := to_char(j, '999999999')||to_char(r, '999,999,999,999,999,999,999')||to_char(r, '9.9EEEE');
    return next;
  end loop;
end;
$body$;

select t from powers_of_two(40);

/*
          1                           2 2.0e+00
          2                           4 4.0e+00
          3                           8 8.0e+00
          4                          16 1.6e+01
          5                          32 3.2e+01
          6                          64 6.4e+01
          7                         128 1.3e+02
          8                         256 2.6e+02
          9                         512 5.1e+02
         10                       1,024 1.0e+03  Kilobyte
         11                       2,048 2.0e+03
         12                       4,096 4.1e+03
         13                       8,192 8.2e+03
         14                      16,384 1.6e+04
         15                      32,768 3.3e+04
         16                      65,536 6.6e+04
         17                     131,072 1.3e+05
         18                     262,144 2.6e+05
         19                     524,288 5.2e+05
         20                   1,048,576 1.0e+06  Megabyte
         21                   2,097,152 2.1e+06
         22                   4,194,304 4.2e+06
         23                   8,388,608 8.4e+06
         24                  16,777,216 1.7e+07
         25                  33,554,432 3.4e+07
         26                  67,108,864 6.7e+07
         27                 134,217,728 1.3e+08
         28                 268,435,456 2.7e+08
         29                 536,870,912 5.4e+08
         30               1,073,741,824 1.1e+09  Gigabyte
         31               2,147,483,648 2.1e+09
         32               4,294,967,296 4.3e+09
         33               8,589,934,592 8.6e+09
         34              17,179,869,184 1.7e+10
         35              34,359,738,368 3.4e+10
         36              68,719,476,736 6.9e+10
         37             137,438,953,472 1.4e+11
         38             274,877,906,944 2.7e+11
         39             549,755,813,888 5.5e+11
         40           1,099,511,627,776 1.1e+12  Terabyte

Petabyte  (PB)  1,125,899,906,842,624
Exabyte   (EB)	1,152,921,504,606,846,976
Zettabyte (ZB)	1,180,591,620,717,411,303,424
Yottabyte (YB)	1,208,925,819,614,629,174,706,176

*/;
