/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Properties;
import javax.net.SocketFactory;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttConnectOptions {
    public static final int KEEP_ALIVE_INTERVAL_DEFAULT = 60;
    public static final int CONNECTION_TIMEOUT_DEFAULT = 8;
    public static final boolean CLEAN_SESSION_DEFAULT = true;
    private int keepAliveInterval = 60;
    private String willDestination = null;
    private MqttMessage willMessage = null;
    private String userName;
    private char[] password;
    private SocketFactory socketFactory;
    private Properties sslClientProps = null;
    private boolean cleanSession = true;
    private int connectionTimeout = 8;
    private static final String[] z;

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] cArray) {
        this.password = cArray;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        if (string != null && string.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        this.userName = string;
    }

    public void setWill(MqttTopic object, byte[] byArray, int n2, boolean bl) {
        object = ((MqttTopic)object).getName();
        this.validateWill((String)object, byArray);
        this.setWill((String)object, new MqttMessage(byArray), n2, bl);
    }

    public void setWill(String string, byte[] byArray, int n2, boolean bl) {
        this.validateWill(string, byArray);
        this.setWill(string, new MqttMessage(byArray), n2, bl);
    }

    private void validateWill(String string, Object object) {
        if (string == null || object == null) {
            throw new IllegalArgumentException();
        }
        MqttAsyncClient.validateTopic(string);
    }

    protected void setWill(String string, MqttMessage mqttMessage, int n2, boolean bl) {
        this.willDestination = string;
        this.willMessage = mqttMessage;
        this.willMessage.setQos(n2);
        this.willMessage.setRetained(bl);
        this.willMessage.setMutable(false);
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveInterval = n2;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int n2) {
        this.connectionTimeout = n2;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public String getWillDestination() {
        return this.willDestination;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public Properties getSSLProperties() {
        return this.sslClientProps;
    }

    public void setSSLProperties(Properties properties) {
        this.sslClientProps = properties;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean bl) {
        this.cleanSession = bl;
    }

    public Properties getDebug() {
        Properties properties = new Properties();
        properties.put(z[3], new Boolean(this.isCleanSession()));
        properties.put(z[6], new Integer(this.getConnectionTimeout()));
        properties.put(z[0], new Integer(this.getKeepAliveInterval()));
        properties.put(z[2], this.getUserName() == null ? z[5] : this.getUserName());
        properties.put(z[4], this.getWillDestination() == null ? z[5] : this.getWillDestination());
        if (this.getSocketFactory() == null) {
            properties.put(z[7], z[5]);
        } else {
            properties.put(z[7], this.getSocketFactory());
        }
        if (this.getSSLProperties() == null) {
            properties.put(z[1], z[5]);
        } else {
            properties.put(z[1], this.getSSLProperties());
        }
        return properties;
    }

    public String toString() {
        return Debug.dumpProperties(this.getDebug(), z[8]);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[9];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "4'Rg:\u0013+Ar2\u00116Re\r\u001e.";
        int n3 = -1;
        block16: while (true) {
            char[] cArray;
            block21: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block20: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block20;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block21;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 127;
                                break;
                            }
                            case 1: {
                                n9 = 66;
                                break;
                            }
                            case 2: {
                                n9 = 55;
                                break;
                            }
                            case 3: {
                                n9 = 23;
                                break;
                            }
                            default: {
                                n9 = 123;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = ",\u0011{G\t\u00102Re\u000f\u0016'D";
                    n3 = 0;
                    continue block16;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "*1Re5\u001e/R";
                    n3 = 1;
                    continue block16;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "<.Rv\u0015,'Dd\u0012\u0010,";
                    n3 = 2;
                    continue block16;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "(+[{?\u001a1C~\u0015\u000b#C~\u0014\u0011";
                    n3 = 3;
                    continue block16;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u00117[{";
                    n3 = 4;
                    continue block16;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "<-YC\u0012\u0012'Xb\u000f";
                    n3 = 5;
                    continue block16;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = ",-T|\u001e\u000b\u0004Vt\u000f\u00100N";
                    n3 = 6;
                    continue block16;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "<-Yy\u001e\u001c6^x\u0015_-Gc\u0012\u0010,D";
                    n3 = 7;
                    continue block16;
                }
                case 7: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

