/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import io.yunba.android.a.k;
import java.util.Vector;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsCallback
implements Runnable {
    private static int INBOUND_QUEUE_SIZE;
    private MqttCallback mqttCallback;
    private ClientComms clientComms;
    private Vector messageQueue;
    private Vector completeQueue;
    public boolean running = false;
    private boolean quiescing = false;
    private Object lifecycle = new Object();
    private Thread callbackThread;
    private Object workAvailable = new Object();
    private Object spaceAvailable = new Object();
    private ClientState clientState;
    static final String className;
    Logger log = LoggerFactory.getLogger(z[23], className);
    private static final String[] z;

    CommsCallback(ClientComms clientComms) {
        this.clientComms = clientComms;
        this.messageQueue = new Vector(INBOUND_QUEUE_SIZE);
        this.completeQueue = new Vector(INBOUND_QUEUE_SIZE);
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    public void setClientState(ClientState clientState) {
        this.clientState = clientState;
    }

    public void start(String string) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.messageQueue.clear();
                this.completeQueue.clear();
                this.running = true;
                this.quiescing = false;
                this.callbackThread = new Thread((Runnable)this, string);
                this.callbackThread.start();
            }
            return;
        }
    }

    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            if (this.running) {
                this.log.fine(className, z[7], z[8]);
                this.running = false;
                if (!Thread.currentThread().equals(this.callbackThread)) {
                    try {
                        Object object2 = this.workAvailable;
                        synchronized (object2) {
                            this.log.fine(className, z[7], z[6]);
                            this.workAvailable.notifyAll();
                        }
                        this.callbackThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.callbackThread = null;
            this.log.fine(className, z[7], z[5]);
            return;
        }
    }

    public void destory() {
        this.running = false;
        try {
            this.callbackThread.interrupt();
        }
        catch (Exception exception) {
            k.h();
        }
        this.callbackThread = null;
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.mqttCallback = mqttCallback;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Object object;
                try {
                    object = this.workAvailable;
                    synchronized (object) {
                        if (this.running & this.messageQueue.isEmpty() && this.completeQueue.isEmpty()) {
                            this.log.fine(className, z[9], z[10]);
                            this.workAvailable.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.running) {
                    if (!this.completeQueue.isEmpty()) {
                        object = (MqttToken)this.completeQueue.elementAt(0);
                        this.handleActionComplete((MqttToken)object);
                        this.completeQueue.removeElementAt(0);
                    }
                    if (!this.messageQueue.isEmpty()) {
                        object = (MqttPublish)this.messageQueue.elementAt(0);
                        this.handleMessage((MqttPublish)object);
                        this.messageQueue.removeElementAt(0);
                    }
                }
                if (this.quiescing) {
                    this.clientState.checkQuiesceLock();
                }
                object = this.spaceAvailable;
                synchronized (object) {
                    this.log.fine(className, z[9], z[12]);
                    this.spaceAvailable.notifyAll();
                }
            }
            catch (Throwable throwable) {
                this.log.fine(className, z[9], z[11], null, throwable);
                this.running = false;
                this.clientComms.shutdownConnection(null, new MqttException(throwable));
            }
        }
    }

    private void handleActionComplete(MqttToken mqttToken) {
        MqttToken mqttToken2 = mqttToken;
        synchronized (mqttToken2) {
            k.b();
            mqttToken.internalTok.notifyComplete();
            if (!mqttToken.internalTok.isNotified()) {
                if (this.mqttCallback != null && mqttToken instanceof MqttDeliveryToken && mqttToken.isComplete()) {
                    this.mqttCallback.deliveryComplete((MqttDeliveryToken)mqttToken);
                }
                this.fireActionEvent(mqttToken);
            }
            if (mqttToken instanceof MqttDeliveryToken && mqttToken.isComplete()) {
                mqttToken.internalTok.setNotified(true);
            }
            if (mqttToken.isComplete()) {
                this.clientState.notifyComplete(mqttToken);
            }
            return;
        }
    }

    public void connectionLost(MqttException mqttException) {
        try {
            if (this.mqttCallback != null && mqttException != null) {
                this.log.fine(className, z[15], z[13], new Object[]{mqttException});
                this.mqttCallback.connectionLost(mqttException);
            }
            return;
        }
        catch (Throwable throwable) {
            this.log.fine(className, z[15], z[14], new Object[]{throwable});
            return;
        }
    }

    public void fireActionEvent(MqttToken mqttToken) {
        IMqttActionListener iMqttActionListener;
        if (mqttToken != null && (iMqttActionListener = mqttToken.getActionCallback()) != null) {
            if (mqttToken.getException() == null) {
                this.log.fine(className, z[17], z[16], new Object[]{mqttToken.internalTok.getKey()});
                iMqttActionListener.onSuccess(mqttToken);
                return;
            }
            this.log.fine(className, z[17], z[16], new Object[]{mqttToken.internalTok.getKey()});
            iMqttActionListener.onFailure(mqttToken, mqttToken.getException());
        }
    }

    public void messageArrived(MqttPublish mqttPublish) {
        if (this.mqttCallback != null) {
            Object object = this.spaceAvailable;
            synchronized (object) {
                if (!this.quiescing && this.messageQueue.size() >= INBOUND_QUEUE_SIZE) {
                    try {
                        this.log.fine(className, z[18], z[20]);
                        this.spaceAvailable.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.quiescing) {
                this.messageQueue.addElement(mqttPublish);
                object = this.workAvailable;
                synchronized (object) {
                    this.log.fine(className, z[18], z[19]);
                    this.workAvailable.notifyAll();
                    return;
                }
            }
        }
    }

    public void quiesce() {
        this.quiescing = true;
        Object object = this.spaceAvailable;
        synchronized (object) {
            this.log.fine(className, z[0], z[1]);
            this.spaceAvailable.notifyAll();
            return;
        }
    }

    public boolean isQuiesced() {
        return this.quiescing && this.completeQueue.size() == 0 && this.messageQueue.size() == 0;
    }

    private void handleMessage(MqttPublish mqttWireMessage) {
        if (this.mqttCallback != null) {
            String string = mqttWireMessage.getTopicName();
            this.log.fine(className, z[21], z[22], new Object[]{new Long(mqttWireMessage.getMessageId()), string});
            this.mqttCallback.messageArrived(string, mqttWireMessage.getMessage());
            if (mqttWireMessage.getMessage().getQos() == 1) {
                this.clientComms.internalSend(new MqttPubAck((MqttPublish)mqttWireMessage), new MqttToken(this.clientComms.getClient().getClientId()));
                return;
            }
            if (mqttWireMessage.getMessage().getQos() == 2) {
                this.clientComms.deliveryComplete((MqttPublish)mqttWireMessage);
                mqttWireMessage = new MqttPubComp((MqttPublish)mqttWireMessage);
                this.clientComms.internalSend(mqttWireMessage, new MqttToken(this.clientComms.getClient().getClientId()));
            }
        }
    }

    public void asyncOperationComplete(MqttToken mqttToken) {
        if (this.running) {
            this.completeQueue.addElement(mqttToken);
            Object object = this.workAvailable;
            synchronized (object) {
                this.log.fine(className, z[3], z[2], new Object[]{mqttToken.internalTok.getKey()});
                this.workAvailable.notifyAll();
            }
        } else {
            try {
                this.handleActionComplete(mqttToken);
                return;
            }
            catch (Throwable throwable) {
                this.log.fine(className, z[3], z[4], null, throwable);
                throwable.printStackTrace();
                this.clientComms.shutdownConnection(null, new MqttException(throwable));
            }
        }
    }

    protected Thread getThread() {
        return this.callbackThread;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[24];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "FN\"v\u001cF@#w\rdB$";
        int n3 = 23;
        block32: while (true) {
            char[] cArray;
            block37: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block36: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block36;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block37;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 5;
                                break;
                            }
                            case 1: {
                                n9 = 33;
                                break;
                            }
                            case 2: {
                                n9 = 79;
                                break;
                            }
                            case 3: {
                                n9 = 27;
                                break;
                            }
                            default: {
                                n9 = 111;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 23: {
                    className = string.intern();
                    string2 = "tT&~\u001cfD";
                    n3 = -1;
                    continue block32;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "2\u0010~";
                    n3 = 0;
                    continue block32;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "2\u0010z";
                    n3 = 1;
                    continue block32;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "dR6u\fJQ*i\u000eqH u,jL?w\nqD";
                    n3 = 2;
                    continue block32;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "2\u0010v";
                    n3 = 3;
                    continue block32;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "2\u0011|";
                    n3 = 4;
                    continue block32;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "2\u0011~";
                    n3 = 5;
                    continue block32;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "vU k";
                    n3 = 6;
                    continue block32;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "2\u0011\u007f";
                    n3 = 7;
                    continue block32;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "wT!";
                    n3 = 8;
                    continue block32;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "2\u0011{";
                    n3 = 9;
                    continue block32;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "2\u0010{";
                    n3 = 10;
                    continue block32;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "2\u0011y";
                    n3 = 11;
                    continue block32;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "2\u0011w";
                    n3 = 12;
                    continue block32;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "2\u0013\u007f";
                    n3 = 13;
                    continue block32;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "fN!u\nfU&t\u0001IN<o";
                    n3 = 14;
                    continue block32;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "2\u0010y";
                    n3 = 15;
                    continue block32;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "cH=~.fU&t\u0001@W*u\u001b";
                    n3 = 16;
                    continue block32;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "hD<h\u000ebD\u000ei\u001dlW*\u007f";
                    n3 = 17;
                    continue block32;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "2\u0010\u007f";
                    n3 = 18;
                    continue block32;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "2\u0011v";
                    n3 = 19;
                    continue block32;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "m@!\u007f\u0003`l*h\u001cdF*";
                    n3 = 20;
                    continue block32;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "2\u0010|";
                    n3 = 21;
                    continue block32;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "jS(5\nfM&k\u001c`\u000f?z\u0007j\u000f,w\u0006`O;5\u0002tU;m\\+H!o\nwO.wAkM<5\u0003jF,z\u001b";
                    n3 = 22;
                    continue block32;
                }
                case 22: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        INBOUND_QUEUE_SIZE = 10;
    }
}

