/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import io.yunba.android.a.k;
import java.io.OutputStream;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttOutputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsSender
implements Runnable {
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;
    private Thread sendThread = null;
    private static final String className;
    private Logger log = LoggerFactory.getLogger(z[9], className);
    private static final String[] z;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore commsTokenStore, OutputStream outputStream) {
        this.out = new MqttOutputStream(outputStream);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = commsTokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    public void start(String string) {
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.sendThread = new Thread((Runnable)this, string);
                this.sendThread.start();
            }
            return;
        }
    }

    public void stop() {
        Object object = this.lifecycle;
        synchronized (object) {
            this.log.fine(className, z[2], z[0]);
            if (this.running) {
                this.running = false;
                if (!Thread.currentThread().equals(this.sendThread)) {
                    try {
                        this.clientState.notifyQueueLock();
                        this.sendThread.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.sendThread = null;
            this.log.fine(className, z[2], z[1]);
            return;
        }
    }

    public void destory() {
        this.running = false;
        try {
            this.sendThread.interrupt();
        }
        catch (Exception exception) {
            k.h();
        }
        this.sendThread = null;
    }

    @Override
    public void run() {
        MqttWireMessage mqttWireMessage = null;
        while (this.running && this.out != null) {
            try {
                mqttWireMessage = this.clientState.get();
                if (mqttWireMessage != null) {
                    String cfr_ignored_0 = z[4] + mqttWireMessage.getKey() + z[7] + mqttWireMessage.getType();
                    k.b();
                    if (mqttWireMessage instanceof MqttAck) {
                        this.out.write(mqttWireMessage);
                        this.out.flush();
                        continue;
                    }
                    MqttToken mqttToken = this.tokenStore.getToken(mqttWireMessage);
                    if (mqttToken != null) {
                        synchronized (mqttToken) {
                            this.out.write(mqttWireMessage);
                            this.out.flush();
                            this.clientState.notifySent(mqttWireMessage);
                            continue;
                        }
                    }
                    String cfr_ignored_1 = z[6] + mqttWireMessage.getKey() + z[7] + mqttWireMessage.getType();
                    k.d();
                    continue;
                }
                this.log.fine(className, z[5], z[8]);
                this.running = false;
            }
            catch (MqttException mqttException) {
                k.h();
                this.handleRunException(mqttWireMessage, mqttException);
            }
            catch (Exception exception) {
                k.h();
                this.handleRunException(mqttWireMessage, exception);
            }
        }
        this.log.fine(className, z[5], z[3]);
    }

    private void handleRunException(MqttWireMessage object, Exception exception) {
        k.b();
        object = !(exception instanceof MqttException) ? new MqttException(32109, (Throwable)exception) : (MqttException)exception;
        this.running = false;
        this.clientComms.shutdownConnection(null, (MqttException)object);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[10];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "0p\u00189X z\u001b0N\u0001";
        int n3 = 9;
        block18: while (true) {
            char[] cArray;
            block23: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block22: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block22;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block23;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 115;
                                break;
                            }
                            case 1: {
                                n9 = 31;
                                break;
                            }
                            case 2: {
                                n9 = 117;
                                break;
                            }
                            case 3: {
                                n9 = 84;
                                break;
                            }
                            default: {
                                n9 = 43;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 9: {
                    className = string.intern();
                    string2 = "K/E";
                    n3 = -1;
                    continue block18;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "K/D";
                    n3 = 0;
                    continue block18;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "\u0000k\u001a$";
                    n3 = 1;
                    continue block18;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "K/@";
                    n3 = 2;
                    continue block18;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "\u001el\u0012\u001dOS\"U";
                    n3 = 3;
                    continue block18;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u0001j\u001b";
                    n3 = 4;
                    continue block18;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "\u001dj\u00198\u000b\u0007p\u001e1ES%\u0018'L:{Ui\u000b";
                    n3 = 5;
                    continue block18;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "St\u0010-\u000bN?";
                    n3 = 6;
                    continue block18;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "K/F";
                    n3 = 7;
                    continue block18;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "\u001cm\u0012zN\u0010s\u001c$X\u00161\u00055C\u001c1\u00168B\u0016q\u0001zF\u0002k\u0001\"\u0018]v\u001b N\u0001q\u00148\u0005\u001ds\u0006zG\u001cx\u00165_";
                    n3 = 8;
                    continue block18;
                }
                case 8: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
    }
}

