/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.security;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.internal.security.SimpleBase64Encoder;
import org.eclipse.paho.client.mqttv3.logging.Logger;

public class SSLSocketFactoryFactory {
    private static final String CLASS_NAME;
    public static final String SSLPROTOCOL;
    public static final String JSSEPROVIDER;
    public static final String KEYSTORE;
    public static final String KEYSTOREPWD;
    public static final String KEYSTORETYPE;
    public static final String KEYSTOREPROVIDER;
    public static final String KEYSTOREMGR;
    public static final String TRUSTSTORE;
    public static final String TRUSTSTOREPWD;
    public static final String TRUSTSTORETYPE;
    public static final String TRUSTSTOREPROVIDER;
    public static final String TRUSTSTOREMGR;
    public static final String CIPHERSUITES;
    public static final String CLIENTAUTH;
    public static final String SYSKEYSTORE;
    public static final String SYSKEYSTORETYPE;
    public static final String SYSKEYSTOREPWD;
    public static final String SYSTRUSTSTORE;
    public static final String SYSTRUSTSTORETYPE;
    public static final String SYSTRUSTSTOREPWD;
    public static final String SYSKEYMGRALGO;
    public static final String SYSTRUSTMGRALGO;
    public static final String DEFAULT_PROTOCOL;
    private static final String[] propertyKeys;
    private Hashtable configs = new Hashtable();
    private Properties defaultProperties;
    private static final byte[] key;
    private static final String xorTag;
    private Logger logger = null;
    private static final String[] z;

    public static boolean isSupportedOnJVM() {
        String string = z[0];
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public SSLSocketFactoryFactory() {
    }

    public SSLSocketFactoryFactory(Logger logger) {
        this();
        this.logger = logger;
    }

    private boolean keyValid(String string) {
        int n2;
        for (n2 = 0; n2 < propertyKeys.length && !propertyKeys[n2].equals(string); ++n2) {
        }
        return n2 < propertyKeys.length;
    }

    private void checkPropertyKeys(Properties iterator) {
        iterator = ((Properties)((Object)iterator)).keySet();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.keyValid(string)) continue;
            throw new IllegalArgumentException(string + z[1]);
        }
    }

    public static char[] toChar(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = new char[byArray.length / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            cArray[n3++] = (char)((byArray[n2++] & 0xFF) + ((byArray[n2++] & 0xFF) << 8));
        }
        return cArray;
    }

    public static byte[] toByte(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            byArray[n2++] = (byte)(cArray[n3] & 0xFF);
            byArray[n2++] = (byte)(cArray[n3++] >> 8 & 0xFF);
        }
        return byArray;
    }

    public static String obfuscate(char[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        objectArray = SSLSocketFactoryFactory.toByte(objectArray);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = (char)((objectArray[i2] ^ key[i2 % key.length]) & 0xFF);
        }
        String string = xorTag + new String(SimpleBase64Encoder.encode((byte[])objectArray));
        return string;
    }

    public static char[] deObfuscate(String object) {
        if (object == null) {
            return null;
        }
        try {
            object = SimpleBase64Encoder.decode(((String)object).substring(5));
        }
        catch (Exception exception) {
            return null;
        }
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            object[i2] = (byte)((object[i2] ^ key[i2 % key.length]) & 0xFF);
        }
        return SSLSocketFactoryFactory.toChar((byte[])object);
    }

    public static String packCipherSuites(String[] stringArray) {
        CharSequence charSequence = null;
        if (stringArray != null) {
            charSequence = new StringBuffer();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                ((StringBuffer)charSequence).append(stringArray[i2]);
                if (i2 >= stringArray.length - 1) continue;
                ((StringBuffer)charSequence).append(',');
            }
            charSequence = ((StringBuffer)charSequence).toString();
        }
        return charSequence;
    }

    public static String[] unpackCipherSuites(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = stringArray.indexOf(44);
        int n3 = 0;
        while (n2 >= 0) {
            vector.add(stringArray.substring(n3, n2));
            n3 = n2 + 1;
            n2 = stringArray.indexOf(44, n3);
        }
        vector.add(stringArray.substring(n3));
        stringArray = new String[vector.size()];
        vector.toArray(stringArray);
        return stringArray;
    }

    private void convertPassword(Properties properties) {
        String string = properties.getProperty(KEYSTOREPWD);
        if (string != null && !string.startsWith(xorTag)) {
            string = SSLSocketFactoryFactory.obfuscate(string.toCharArray());
            properties.put(KEYSTOREPWD, string);
        }
        if ((string = properties.getProperty(TRUSTSTOREPWD)) != null && !string.startsWith(xorTag)) {
            string = SSLSocketFactoryFactory.obfuscate(string.toCharArray());
            properties.put(TRUSTSTOREPWD, string);
        }
    }

    public void initialize(Properties properties, String string) {
        this.checkPropertyKeys(properties);
        Properties properties2 = new Properties();
        properties2.putAll((Map<?, ?>)properties);
        this.convertPassword(properties2);
        if (string != null) {
            this.configs.put(string, properties2);
            return;
        }
        this.defaultProperties = properties2;
    }

    public void merge(Properties properties, String string) {
        this.checkPropertyKeys(properties);
        Properties properties2 = this.defaultProperties;
        if (string == null) {
            properties2 = (Properties)this.configs.get(string);
        }
        if (properties2 == null) {
            properties2 = new Properties();
        }
        this.convertPassword(properties);
        properties2.putAll((Map<?, ?>)properties);
        if (string != null) {
            this.configs.put(string, properties2);
            return;
        }
        this.defaultProperties = properties2;
    }

    public boolean remove(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.configs.remove(string) != null;
        } else if (this.defaultProperties != null) {
            bl = true;
            this.defaultProperties = null;
        }
        return bl;
    }

    public Properties getConfiguration(String string) {
        return string == null ? this.defaultProperties : this.configs.get(string);
    }

    private String getProperty(String string, String string2, String string3) {
        if ((string = this.getPropertyFromConfig(string, string2)) != null) {
            return string;
        }
        if (string3 != null) {
            string = System.getProperty(string3);
        }
        return string;
    }

    private String getPropertyFromConfig(String string, String string2) {
        String string3 = null;
        Properties properties = null;
        if (string != null) {
            properties = (Properties)this.configs.get(string);
        }
        if (properties != null && (string3 = properties.getProperty(string2)) != null) {
            return string3;
        }
        properties = this.defaultProperties;
        if (properties != null && (string3 = properties.getProperty(string2)) != null) {
            return string3;
        }
        return string3;
    }

    public String getSSLProtocol(String string) {
        return this.getProperty(string, SSLPROTOCOL, null);
    }

    public String getJSSEProvider(String string) {
        return this.getProperty(string, JSSEPROVIDER, null);
    }

    public String getKeyStore(String string) {
        String string2 = KEYSTORE;
        String string3 = SYSKEYSTORE;
        if ((string = this.getPropertyFromConfig(string, string2)) != null) {
            return string;
        }
        string = System.getProperty(string3);
        return string;
    }

    public char[] getKeyStorePassword(String string) {
        string = this.getProperty(string, KEYSTOREPWD, SYSKEYSTOREPWD);
        char[] cArray = null;
        if (string != null) {
            cArray = string.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(string) : string.toCharArray();
        }
        return cArray;
    }

    public String getKeyStoreType(String string) {
        return this.getProperty(string, KEYSTORETYPE, SYSKEYSTORETYPE);
    }

    public String getKeyStoreProvider(String string) {
        return this.getProperty(string, KEYSTOREPROVIDER, null);
    }

    public String getKeyManager(String string) {
        return this.getProperty(string, KEYSTOREMGR, SYSKEYMGRALGO);
    }

    public String getTrustStore(String string) {
        return this.getProperty(string, TRUSTSTORE, SYSTRUSTSTORE);
    }

    public char[] getTrustStorePassword(String string) {
        string = this.getProperty(string, TRUSTSTOREPWD, SYSTRUSTSTOREPWD);
        char[] cArray = null;
        if (string != null) {
            cArray = string.startsWith(xorTag) ? SSLSocketFactoryFactory.deObfuscate(string) : string.toCharArray();
        }
        return cArray;
    }

    public String getTrustStoreType(String string) {
        return this.getProperty(string, TRUSTSTORETYPE, null);
    }

    public String getTrustStoreProvider(String string) {
        return this.getProperty(string, TRUSTSTOREPROVIDER, null);
    }

    public String getTrustManager(String string) {
        return this.getProperty(string, TRUSTSTOREMGR, SYSTRUSTMGRALGO);
    }

    public String[] getEnabledCipherSuites(String stringArray) {
        stringArray = this.getProperty((String)stringArray, CIPHERSUITES, null);
        stringArray = SSLSocketFactoryFactory.unpackCipherSuites((String)stringArray);
        return stringArray;
    }

    public boolean getClientAuthentication(String string) {
        string = this.getProperty(string, CLIENTAUTH, null);
        boolean bl = false;
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    private SSLContext getSSLContext(String string) {
        Object object = null;
        object = this.getSSLProtocol(string);
        if (object == null) {
            object = DEFAULT_PROTOCOL;
        }
        if (this.logger != null) {
            this.logger.fine(CLASS_NAME, z[12], z[11], new Object[]{string != null ? string : z[3], object});
        }
        String string2 = this.getJSSEProvider(string);
        try {
            object = string2 == null ? SSLContext.getInstance((String)object) : SSLContext.getInstance((String)object, string2);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, z[12], z[19], new Object[]{string != null ? string : z[3], ((SSLContext)object).getProvider().getName()});
            }
            string2 = this.getProperty(string, KEYSTORE, null);
            KeyManager[] keyManagerArray = null;
            Object object2 = null;
            keyManagerArray = null;
            if (string2 == null) {
                string2 = this.getProperty(string, KEYSTORE, SYSKEYSTORE);
            }
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, z[12], z[9], new Object[]{string != null ? string : z[3], string2 != null ? string2 : z[14]});
            }
            Object object3 = this.getKeyStorePassword(string);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, z[12], z[10], new Object[]{string != null ? string : z[3], object3 != null ? SSLSocketFactoryFactory.obfuscate((char[])object3) : z[14]});
            }
            if ((object2 = this.getKeyStoreType(string)) == null) {
                object2 = KeyStore.getDefaultType();
            }
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, z[12], z[15], new Object[]{string != null ? string : z[3], object2 != null ? object2 : z[14]});
            }
            Object object4 = KeyManagerFactory.getDefaultAlgorithm();
            TrustManager[] trustManagerArray = this.getKeyStoreProvider(string);
            Object object5 = this.getKeyManager(string);
            if (object5 != null) {
                object4 = object5;
            }
            if (string2 != null && object2 != null && object4 != null) {
                try {
                    keyManagerArray = KeyStore.getInstance((String)object2);
                    keyManagerArray.load(new FileInputStream(string2), (char[])object3);
                    object2 = trustManagerArray != null ? KeyManagerFactory.getInstance((String)object4, (String)trustManagerArray) : KeyManagerFactory.getInstance((String)object4);
                    if (this.logger != null) {
                        this.logger.fine(CLASS_NAME, z[12], z[8], new Object[]{string != null ? string : z[3], object4 != null ? object4 : z[14]});
                        this.logger.fine(CLASS_NAME, z[12], z[6], new Object[]{string != null ? string : z[3], ((KeyManagerFactory)object2).getProvider().getName()});
                    }
                    ((KeyManagerFactory)object2).init((KeyStore)keyManagerArray, (char[])object3);
                    keyManagerArray = ((KeyManagerFactory)object2).getKeyManagers();
                }
                catch (KeyStoreException keyStoreException) {
                    throw new MqttSecurityException(keyStoreException);
                }
                catch (CertificateException certificateException) {
                    throw new MqttSecurityException(certificateException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new MqttSecurityException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new MqttSecurityException(iOException);
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    throw new MqttSecurityException(unrecoverableKeyException);
                }
            }
            object3 = this.getTrustStore(string);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, z[12], z[13], new Object[]{string != null ? string : z[3], (char[])(object3 != null ? object3 : (char[])z[14])});
            }
            trustManagerArray = null;
            object5 = this.getTrustStorePassword(string);
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, z[12], z[18], new Object[]{string != null ? string : z[3], object5 != null ? SSLSocketFactoryFactory.obfuscate((char[])object5) : z[14]});
            }
            if ((string2 = this.getTrustStoreType(string)) == null) {
                string2 = KeyStore.getDefaultType();
            }
            if (this.logger != null) {
                this.logger.fine(CLASS_NAME, z[12], z[17], new Object[]{string != null ? string : z[3], string2 != null ? string2 : z[14]});
            }
            Object object6 = TrustManagerFactory.getDefaultAlgorithm();
            object4 = this.getTrustStoreProvider(string);
            object2 = this.getTrustManager(string);
            if (object2 != null) {
                object6 = object2;
            }
            if (object3 != null && string2 != null && object6 != null) {
                try {
                    object2 = KeyStore.getInstance(string2);
                    ((KeyStore)object2).load(new FileInputStream((String)object3), (char[])object5);
                    object4 = object4 != null ? TrustManagerFactory.getInstance((String)object6, (String)object4) : TrustManagerFactory.getInstance((String)object6);
                    if (this.logger != null) {
                        this.logger.fine(CLASS_NAME, z[12], z[16], new Object[]{string != null ? string : z[3], object6 != null ? object6 : z[14]});
                        this.logger.fine(CLASS_NAME, z[12], z[7], new Object[]{string != null ? string : z[3], ((TrustManagerFactory)object4).getProvider().getName()});
                    }
                    ((TrustManagerFactory)object4).init((KeyStore)object2);
                    trustManagerArray = ((TrustManagerFactory)object4).getTrustManagers();
                }
                catch (KeyStoreException keyStoreException) {
                    throw new MqttSecurityException(keyStoreException);
                }
                catch (CertificateException certificateException) {
                    throw new MqttSecurityException(certificateException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new MqttSecurityException(fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new MqttSecurityException(iOException);
                }
            }
            ((SSLContext)object).init(keyManagerArray, trustManagerArray, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MqttSecurityException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new MqttSecurityException(noSuchProviderException);
        }
        catch (KeyManagementException keyManagementException) {
            throw new MqttSecurityException(keyManagementException);
        }
        return object;
    }

    public SSLSocketFactory createSocketFactory(String string) {
        SSLContext sSLContext = this.getSSLContext(string);
        if (this.logger != null) {
            this.logger.fine(CLASS_NAME, z[2], z[4], new Object[]{string != null ? string : z[3], this.getEnabledCipherSuites(string) != null ? this.getProperty(string, CIPHERSUITES, null) : z[5]});
        }
        return sSLContext.getSocketFactory();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[20];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "$\u0013\noX%\u0011I2B+R\f$H\n\u001d\t V\"\u000e";
        int n3 = 19;
        block52: while (true) {
            char[] cArray;
            block57: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block56: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block56;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block57;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 71;
                                break;
                            }
                            case 1: {
                                n9 = 124;
                                break;
                            }
                            case 2: {
                                n9 = 103;
                                break;
                            }
                            case 3: {
                                n9 = 65;
                                break;
                            }
                            default: {
                                n9 = 49;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                case 19: {
                    KEYSTOREMGR = string.intern();
                    string2 = "4\u000f\u000boe5\t\u00145|&\u0012\u0006&T5:\u0006\"E(\u000e\u001eoP+\u001b\b3X3\u0014\n";
                    n3 = 20;
                    continue block52;
                }
                case 20: {
                    SYSTRUSTMGRALGO = string.intern();
                    string2 = "\u001304";
                    n3 = 21;
                    continue block52;
                }
                case 21: {
                    DEFAULT_PROTOCOL = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u00133D4\b45^5\u00197 B4\u000b\b3U";
                    n3 = 22;
                    continue block52;
                }
                case 22: {
                    TRUSTSTOREPWD = string.intern();
                    string2 = "-\u001d\u0011 Ii\u0012\u00025\u001f4\u000f\u000boZ\"\u000545^5\u0019";
                    n3 = 23;
                    continue block52;
                }
                case 23: {
                    SYSKEYSTORE = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u00133D4\b45^5\u0019";
                    n3 = 24;
                    continue block52;
                }
                case 24: {
                    TRUSTSTORE = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u00133D4\b45^5\u001973^1\u0015\u0003$C";
                    n3 = 25;
                    continue block52;
                }
                case 25: {
                    TRUSTSTOREPROVIDER = string.intern();
                    string2 = "<\u0004\b3L";
                    n3 = 26;
                    continue block52;
                }
                case 26: {
                    xorTag = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u00133D4\b45^5\u001938A\"";
                    n3 = 27;
                    continue block52;
                }
                case 27: {
                    TRUSTSTORETYPE = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\f$H\u0014\b\b3T";
                    n3 = 28;
                    continue block52;
                }
                case 28: {
                    KEYSTORE = string.intern();
                    string2 = "-\u001d\u0011 Ii\u0012\u00025\u001f4\u000f\u000boZ\"\u000545^5\u001938A\"";
                    n3 = 29;
                    continue block52;
                }
                case 29: {
                    SYSKEYSTORETYPE = string.intern();
                    string2 = "-\u001d\u0011 Ii\u0012\u00025\u001f4\u000f\u000boE5\t\u00145b3\u0013\u0015$a&\u000f\u00146^5\u0018";
                    n3 = 30;
                    continue block52;
                }
                case 30: {
                    SYSTRUSTSTOREPWD = string.intern();
                    string2 = "-\u001d\u0011 Ii\u0012\u00025\u001f4\u000f\u000boE5\t\u00145b3\u0013\u0015$e>\f\u0002";
                    n3 = 31;
                    continue block52;
                }
                case 31: {
                    SYSTRUSTSTORETYPE = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\f$H\u0014\b\b3T\u0017\u000e\b7X#\u0019\u0015";
                    n3 = 32;
                    continue block52;
                }
                case 32: {
                    KEYSTOREPROVIDER = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\f$H\u0014\b\b3T\u0013\u0005\u0017$";
                    n3 = 33;
                    continue block52;
                }
                case 33: {
                    KEYSTORETYPE = string.intern();
                    string2 = "(\u000e\u0000oT$\u0010\u000e1B\"R\u0017 Y(R\u0004-X\"\u0012\u0013o\\6\b\u00137\u0002i\u0015\t5T5\u0012\u0006-\u001f4\u0019\u00044C.\b\u001eob\u001404.R,\u0019\u0013\u0007P$\b\b3H\u0001\u001d\u00045^5\u0005";
                    n3 = 34;
                    continue block52;
                }
                case 34: {
                    CLASS_NAME = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u0004-X\"\u0012\u0013\u0000D3\u0014\u0002/E.\u001f\u00065X(\u0012";
                    n3 = 35;
                    continue block52;
                }
                case 35: {
                    CLIENTAUTH = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u0004._3\u0019\u001f5a5\u0013\u0011(U\"\u000e";
                    n3 = 36;
                    continue block52;
                }
                case 36: {
                    JSSEPROVIDER = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u00173^3\u0013\u0004.]";
                    n3 = 37;
                    continue block52;
                }
                case 37: {
                    SSLPROTOCOL = string.intern();
                    string2 = "4\u000f\u000boz\"\u0005* _&\u001b\u00023w&\u001f\u0013.C>R\u0006-V(\u000e\u000e5Y*";
                    n3 = 38;
                    continue block52;
                }
                case 38: {
                    SYSKEYMGRALGO = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\f$H\u0014\b\b3T\u0017\u001d\u00142F(\u000e\u0003";
                    n3 = 39;
                    continue block52;
                }
                case 39: {
                    KEYSTOREPWD = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u00133D4\b* _&\u001b\u00023";
                    n3 = 40;
                    continue block52;
                }
                case 40: {
                    TRUSTSTOREMGR = string.intern();
                    string2 = "-\u001d\u0011 Ii\u0012\u00025\u001f4\u000f\u000boE5\t\u00145b3\u0013\u0015$";
                    n3 = 41;
                    continue block52;
                }
                case 41: {
                    SYSTRUSTSTORE = string.intern();
                    string2 = "$\u0013\noX%\u0011I2B+R\u0002/P%\u0010\u0002%r.\f\u000f$C\u0014\t\u000e5T4";
                    n3 = 42;
                    continue block52;
                }
                case 42: {
                    CIPHERSUITES = string.intern();
                    string2 = "-\u001d\u0011 Ii\u0012\u00025\u001f4\u000f\u000boZ\"\u000545^5\u00197 B4\u000b\b3U";
                    n3 = 43;
                    continue block52;
                }
                case 43: {
                    SYSKEYSTOREPWD = string.intern();
                    string2 = "-\u001d\u0011 Ii\u0012\u00025\u001f4\u000f\u000bob\u001404$C1\u0019\u0015\u0012^$\u0017\u00025w&\u001f\u0013.C>";
                    n3 = -1;
                    continue block52;
                }
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "g\u0015\u0014a_(\bG \u00111\u001d\u000b(Ug5%\f\u0011\u0014/+aA5\u0013\u0017$C3\u0005G*T>R";
                    n3 = 0;
                    continue block52;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "$\u000e\u0002 E\"/\b\"Z\"\b! R3\u0013\u00158";
                    n3 = 1;
                    continue block52;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = ")\t\u000b-\u0011o\u001e\u0015.Z\"\u000eG%T!\u001d\u0012-E4U";
                    n3 = 2;
                    continue block52;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "vNWs\u0001";
                    n3 = 3;
                    continue block52;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = ")\t\u000b-\u0011o\t\u0014(_ \\\u0017-P3\u001a\b3\\j\u0019\t S+\u0019\u0003aR.\f\u000f$Cg\u000f\u0012(E\"\u000fN";
                    n3 = 4;
                    continue block52;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "vNWq\b";
                    n3 = 5;
                    continue block52;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "vNWp\u0007";
                    n3 = 6;
                    continue block52;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "vNWp\u0001";
                    n3 = 7;
                    continue block52;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "vNWq\u0005";
                    n3 = 8;
                    continue block52;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "vNWq\u0004";
                    n3 = 9;
                    continue block52;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "vNWq\u0001";
                    n3 = 10;
                    continue block52;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = " \u0019\u0013\u0012b\u000b?\b/E\"\u0004\u0013";
                    n3 = 11;
                    continue block52;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "vNWp\u0000";
                    n3 = 12;
                    continue block52;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = ")\t\u000b-";
                    n3 = 13;
                    continue block52;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "vNWq\u0007";
                    n3 = 14;
                    continue block52;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "vNWp\u0006";
                    n3 = 15;
                    continue block52;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "vNWp\u0002";
                    n3 = 16;
                    continue block52;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "vNWp\u0003";
                    n3 = 17;
                    continue block52;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "vNWq\u0000";
                    n3 = 18;
                    continue block52;
                }
                case 18: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        propertyKeys = new String[]{SSLPROTOCOL, JSSEPROVIDER, KEYSTORE, KEYSTOREPWD, KEYSTORETYPE, KEYSTOREPROVIDER, KEYSTOREMGR, TRUSTSTORE, TRUSTSTOREPWD, TRUSTSTORETYPE, TRUSTSTOREPROVIDER, TRUSTSTOREMGR, CIPHERSUITES, CLIENTAUTH};
        key = new byte[]{-99, -89, -39, -128, 5, -72, -119, -100};
    }
}

