/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.CountingInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttConnack;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttExpandAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingResp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubComp;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRec;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPubRel;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MultiByteArrayInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MultiByteInteger;

public abstract class MqttWireMessage {
    protected static final String STRING_ENCODING;
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    public static final byte MESSAGE_TYPE_EXPAND = 15;
    private byte type;
    protected long msgId;
    protected boolean duplicate = false;
    private byte[] encodedHeader = null;

    public MqttWireMessage(byte by) {
        this.type = by;
        this.msgId = 0L;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() {
        return new byte[0];
    }

    public byte getType() {
        return this.type;
    }

    public long getMessageId() {
        return this.msgId;
    }

    public void setMessageId(long l2) {
        this.msgId = l2;
    }

    public String getKey() {
        return new Long(this.getMessageId()).toString();
    }

    public byte[] getHeader() {
        if (this.encodedHeader == null) {
            try {
                int n2 = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
                byte[] byArray = this.getVariableHeader();
                int n3 = byArray.length + this.getPayload().length;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeByte(n2);
                dataOutputStream.write(MqttWireMessage.encodeMBI(n3));
                dataOutputStream.write(byArray);
                dataOutputStream.flush();
                this.encodedHeader = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new MqttException(-112, (Throwable)iOException);
            }
        }
        return this.encodedHeader;
    }

    protected abstract byte[] getVariableHeader();

    public boolean isMessageIdRequired() {
        return true;
    }

    public static MqttWireMessage createWireMessage(MqttPersistable object) {
        byte[] byArray = object.getPayloadBytes();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        object = new MultiByteArrayInputStream(object.getHeaderBytes(), object.getHeaderOffset(), object.getHeaderLength(), byArray, object.getPayloadOffset(), object.getPayloadLength());
        return MqttWireMessage.createWireMessage((InputStream)object);
    }

    public static MqttWireMessage createWireMessage(byte[] object) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        object = byteArrayInputStream;
        return MqttWireMessage.createWireMessage(byteArrayInputStream);
    }

    private static MqttWireMessage createWireMessage(InputStream object) {
        try {
            object = new CountingInputStream((InputStream)object);
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            int by = dataInputStream.readUnsignedByte();
            byte by2 = (byte)(by >> 4);
            byte by3 = (byte)(by & 0xF);
            long l2 = MqttWireMessage.readMBI(dataInputStream).getValue();
            long l3 = (long)((CountingInputStream)object).getCounter() + l2;
            long l4 = l3 - (long)((CountingInputStream)object).getCounter();
            object = new byte[0];
            if (l4 > 0L) {
                object = new byte[(int)l4];
                dataInputStream.readFully((byte[])object, 0, ((Object)object).length);
            }
            if (by2 == 3) {
                object = new MqttPublish(by3, (byte[])object);
            } else if (by2 == 4) {
                object = new MqttPubAck(by3, (byte[])object);
            } else if (by2 == 7) {
                object = new MqttPubComp(by3, (byte[])object);
            } else if (by2 == 2) {
                object = new MqttConnack(by3, (byte[])object);
            } else if (by2 == 13) {
                object = new MqttPingResp(by3, (byte[])object);
            } else if (by2 == 9) {
                object = new MqttSuback(by3, (byte[])object);
            } else if (by2 == 11) {
                object = new MqttUnsubAck(by3, (byte[])object);
            } else if (by2 == 6) {
                object = new MqttPubRel(by3, (byte[])object);
            } else if (by2 == 5) {
                object = new MqttPubRec(by3, (byte[])object);
            } else if (by2 == 15) {
                object = new MqttExpandAck(by3, (byte[])object);
            } else {
                throw ExceptionHelper.createMqttException(6);
            }
            return object;
        }
        catch (Exception exception) {
            throw new MqttException(-106, (Throwable)exception);
        }
    }

    protected static byte[] encodeMBI(long l2) {
        int n2 = 0;
        long l3 = l2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            byte by = (byte)(l3 % 128L);
            if ((l3 /= 128L) > 0L) {
                by = (byte)(by | 0x80);
            }
            byteArrayOutputStream.write(by);
        } while (l3 > 0L && ++n2 < 4);
        return byteArrayOutputStream.toByteArray();
    }

    protected static MultiByteInteger readMBI(DataInputStream dataInputStream) {
        byte by;
        long l2 = 0L;
        int n2 = 1;
        int n3 = 0;
        do {
            by = dataInputStream.readByte();
            ++n3;
            l2 += (long)((by & 0x7F) * n2);
            n2 *= 128;
        } while ((by & 0x80) != 0);
        return new MultiByteInteger(l2, n3);
    }

    protected byte[] encodeMessageId() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(this.msgId);
            dataOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new MqttException(-108, (Throwable)iOException);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    public void setDuplicate(boolean bl) {
        this.duplicate = bl;
    }

    protected void encodeUTF8(DataOutputStream dataOutputStream, String object) {
        try {
            byte[] byArray = ((String)object).getBytes(STRING_ENCODING);
            object = byArray;
            byte by = (byte)(byArray.length >>> 8 & 0xFF);
            byte by2 = (byte)(((Object)object).length >>> 0 & 0xFF);
            dataOutputStream.write(by);
            dataOutputStream.write(by2);
            dataOutputStream.write((byte[])object);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MqttException(-109, (Throwable)unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new MqttException(-110, (Throwable)iOException);
        }
    }

    protected String decodeUTF8(DataInputStream dataInputStream) {
        try {
            int n2 = dataInputStream.readUnsignedShort();
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            return new String(byArray, STRING_ENCODING);
        }
        catch (IOException iOException) {
            throw new MqttException(-107, (Throwable)iOException);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block10: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block9: {
                char[] cArray3 = "x\u0015<S&".toCharArray();
                n4 = 0;
                int n5 = cArray3.length;
                cArray2 = cArray3;
                n3 = n5;
                if (n5 <= 1) break block9;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block10;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n6 = n4;
                while (true) {
                    int n7;
                    char c2 = cArray4[n6];
                    switch (n4 % 5) {
                        case 0: {
                            n7 = 45;
                            break;
                        }
                        case 1: {
                            n7 = 65;
                            break;
                        }
                        case 2: {
                            n7 = 122;
                            break;
                        }
                        case 3: {
                            n7 = 126;
                            break;
                        }
                        default: {
                            n7 = 30;
                        }
                    }
                    cArray4[n6] = (char)(c2 ^ n7);
                    ++n4;
                    cArray2 = cArray5;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray5 = cArray2;
                    n2 = n3;
                    n6 = n3;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        STRING_ENCODING = new String(cArray).intern();
    }
}

