/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import io.yunba.android.a.k;
import io.yunba.android.core.b;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.LocalNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttExpand;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttExpandPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPingReq;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.util.Debug;
import org.json.JSONObject;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private static final int URI_TYPE_TCP = 0;
    private static final int URI_TYPE_SSL = 1;
    private static final int URI_TYPE_LOCAL = 2;
    private String clientId;
    private String serverURI;
    private int serverURIType;
    protected ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    static final String className;
    public Logger log = LoggerFactory.getLogger(z[27], className);
    private static final String[] z;

    public MqttAsyncClient(String string, String string2) {
        this(string, string2, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String string, String string2, MqttClientPersistence mqttClientPersistence) {
        this.log.setResourceName(string2);
        if (string2 == null || string2.length() == 0 || string2.length() > 23) {
            throw new IllegalArgumentException();
        }
        this.serverURI = string;
        this.serverURIType = this.validateURI(string);
        this.clientId = string2;
        this.persistence = mqttClientPersistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.log.fine(className, z[29], z[28], new Object[]{string2, string, mqttClientPersistence});
        this.persistence.open(string2, string);
        this.comms = new ClientComms(this, this.persistence);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    private int validateURI(String string) {
        if (string.startsWith(z[20])) {
            return 0;
        }
        if (string.startsWith(z[19])) {
            return 1;
        }
        if (string.startsWith(z[21])) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    protected NetworkModule createNetworkModule(String object, MqttConnectOptions mqttConnectOptions) {
        this.log.fine(className, z[26], z[25], new Object[]{object});
        Object object2 = mqttConnectOptions.getSocketFactory();
        switch (this.serverURIType) {
            case 0: {
                object = ((String)object).substring(6);
                String string = this.getHostName((String)object);
                int n2 = this.getPort((String)object, 1883);
                if (object2 == null) {
                    object2 = SocketFactory.getDefault();
                    mqttConnectOptions.setSocketFactory((SocketFactory)object2);
                } else if (object2 instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                object = new TCPNetworkModule((SocketFactory)object2, string, n2, this.clientId);
                ((TCPNetworkModule)object).setConnectTimeout(mqttConnectOptions.getConnectionTimeout());
                break;
            }
            case 1: {
                object = ((String)object).substring(6);
                String string = this.getHostName((String)object);
                int n3 = this.getPort((String)object, 8883);
                SSLSocketFactoryFactory sSLSocketFactoryFactory = null;
                if (object2 == null) {
                    sSLSocketFactoryFactory = new SSLSocketFactoryFactory();
                    object2 = mqttConnectOptions.getSSLProperties();
                    if (object2 != null) {
                        sSLSocketFactoryFactory.initialize((Properties)object2, null);
                    }
                    object2 = sSLSocketFactoryFactory.createSocketFactory(null);
                } else if (!(object2 instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                object = new SSLNetworkModule((SSLSocketFactory)object2, string, n3, this.clientId);
                ((SSLNetworkModule)object).setSSLhandshakeTimeout(mqttConnectOptions.getConnectionTimeout());
                if (sSLSocketFactoryFactory == null || (object2 = sSLSocketFactoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)object).setEnabledCiphers((String[])object2);
                break;
            }
            case 2: {
                object = new LocalNetworkModule(((String)object).substring(8));
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    private int getPort(String string, int n2) {
        int n3 = string.lastIndexOf(58);
        int n4 = n3 == -1 ? n2 : Integer.valueOf(string.substring(n3 + 1));
        return n4;
    }

    private String getHostName(String string) {
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(58);
        if (n3 == -1) {
            n3 = string.length();
        }
        return string.substring(n2 + 1, n3);
    }

    @Override
    public IMqttToken connect(Object object, IMqttActionListener iMqttActionListener) {
        return this.connect(new MqttConnectOptions(), object, iMqttActionListener);
    }

    @Override
    public IMqttToken connect() {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions mqttConnectOptions) {
        return this.connect(mqttConnectOptions, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions mqttConnectOptions, Object object, IMqttActionListener iMqttActionListener) {
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.log.fine(className, z[10], z[8], new Object[]{new Boolean(mqttConnectOptions.isCleanSession()), new Integer(mqttConnectOptions.getConnectionTimeout()), new Integer(mqttConnectOptions.getKeepAliveInterval()), mqttConnectOptions.getUserName(), null == mqttConnectOptions.getPassword() ? z[9] : z[7], null == mqttConnectOptions.getWillMessage() ? z[9] : z[7], object, iMqttActionListener});
        this.comms.setNetworkModule(this.createNetworkModule(this.serverURI, mqttConnectOptions));
        this.persistence.open(this.clientId, this.serverURI);
        if (mqttConnectOptions.isCleanSession()) {
            this.persistence.clear();
        }
        MqttToken mqttToken = new MqttToken(this.getClientId());
        mqttToken.setActionCallback(iMqttActionListener);
        mqttToken.setUserContext(object);
        this.comms.connect(mqttConnectOptions, mqttToken);
        return mqttToken;
    }

    @Override
    public IMqttToken disconnect(Object object, IMqttActionListener iMqttActionListener) {
        return this.disconnect(30000L, object, iMqttActionListener);
    }

    @Override
    public IMqttToken disconnect() {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long l2) {
        return this.disconnect(l2, null, null);
    }

    @Override
    public IMqttToken disconnect(long l2, Object object, IMqttActionListener iMqttActionListener) {
        this.log.fine(className, z[15], z[16], new Object[]{new Long(l2), object, iMqttActionListener});
        MqttToken mqttToken = new MqttToken(this.getClientId());
        mqttToken.setActionCallback(iMqttActionListener);
        mqttToken.setUserContext(object);
        object = new MqttDisconnect();
        try {
            this.comms.disconnect((MqttDisconnect)object, l2, mqttToken);
        }
        catch (MqttException mqttException) {
            this.log.fine(className, z[15], z[17], null, mqttException);
            throw mqttException;
        }
        this.log.fine(className, z[15], z[14]);
        return mqttToken;
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    public boolean isConnecting() {
        return this.comms.isConnecting();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    protected MqttTopic getTopic(String string) {
        MqttAsyncClient.validateTopic(string);
        MqttTopic mqttTopic = (MqttTopic)this.topics.get(string);
        if (mqttTopic == null) {
            mqttTopic = new MqttTopic(string, this.comms);
            this.topics.put(string, mqttTopic);
        }
        return mqttTopic;
    }

    @Override
    public IMqttToken subscribe(String string, int n2, Object object, IMqttActionListener iMqttActionListener) {
        return this.subscribe(new String[]{string}, new int[]{n2}, object, iMqttActionListener);
    }

    @Override
    public IMqttToken subscribe(String string, int n2) {
        return this.subscribe(new String[]{string}, new int[]{n2}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] stringArray, int[] nArray) {
        return this.subscribe(stringArray, nArray, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] object, int[] nArray, Object object2, IMqttActionListener iMqttActionListener) {
        if (((String[])object).length != nArray.length) {
            throw new IllegalArgumentException();
        }
        String string = "";
        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
            if (i2 > 0) {
                string = string + z[6];
            }
            string = string + object[i2] + ":" + nArray[i2];
        }
        this.log.fine(className, z[24], z[23], new Object[]{string, object2, iMqttActionListener});
        MqttToken mqttToken = new MqttToken(this.getClientId());
        mqttToken.setActionCallback(iMqttActionListener);
        mqttToken.setUserContext(object2);
        mqttToken.internalTok.setTopics((String[])object);
        object = new MqttSubscribe((String[])object, nArray);
        this.comms.sendNoWait((MqttWireMessage)object, mqttToken);
        this.log.fine(className, z[24], z[22]);
        return mqttToken;
    }

    @Override
    public IMqttToken unsubscribe(String string, Object object, IMqttActionListener iMqttActionListener) {
        return this.unsubscribe(new String[]{string}, object, iMqttActionListener);
    }

    @Override
    public IMqttToken unsubscribe(String string) {
        return this.unsubscribe(new String[]{string}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] stringArray) {
        return this.unsubscribe(stringArray, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] object, Object object2, IMqttActionListener iMqttActionListener) {
        String string = "";
        for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
            if (i2 > 0) {
                string = string + z[6];
            }
            string = string + object[i2];
        }
        this.log.fine(className, z[5], z[3], new Object[]{string, object2, iMqttActionListener});
        MqttToken mqttToken = new MqttToken(this.getClientId());
        mqttToken.setActionCallback(iMqttActionListener);
        mqttToken.setUserContext(object2);
        mqttToken.internalTok.setTopics((String[])object);
        object = new MqttUnsubscribe((String[])object);
        this.comms.sendNoWait((MqttWireMessage)object, mqttToken);
        this.log.fine(className, z[5], z[4]);
        return mqttToken;
    }

    @Override
    public void setCallback(MqttCallback mqttCallback) {
        this.comms.setCallback(mqttCallback);
    }

    public static String generateClientId() {
        return System.getProperty(z[18]) + "." + System.currentTimeMillis();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String string, byte[] object, int n2, boolean bl, Object object2, IMqttActionListener iMqttActionListener) {
        MqttMessage mqttMessage = new MqttMessage((byte[])object);
        object = mqttMessage;
        mqttMessage.setQos(n2);
        ((MqttMessage)object).setRetained(bl);
        return this.publish(string, (MqttMessage)object, object2, iMqttActionListener);
    }

    @Override
    public IMqttDeliveryToken publish(String string, byte[] byArray, int n2, boolean bl) {
        return this.publish(string, byArray, n2, bl, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String string, MqttMessage mqttMessage) {
        return this.publish(string, mqttMessage, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String object, MqttMessage mqttMessage, Object object2, IMqttActionListener iMqttActionListener) {
        this.log.fine(className, z[13], z[11], new Object[]{object, object2, iMqttActionListener});
        MqttAsyncClient.validateTopic((String)object);
        MqttDeliveryToken mqttDeliveryToken = new MqttDeliveryToken(this.getClientId());
        mqttDeliveryToken.setActionCallback(iMqttActionListener);
        mqttDeliveryToken.setUserContext(object2);
        mqttDeliveryToken.setMessage(mqttMessage);
        mqttDeliveryToken.internalTok.setTopics(new String[]{object});
        object = new MqttPublish((String)object, mqttMessage);
        this.comms.sendNoWait((MqttWireMessage)object, mqttDeliveryToken);
        this.log.fine(className, z[13], z[12]);
        return mqttDeliveryToken;
    }

    @Override
    public void close() {
        this.log.fine(className, z[1], z[2]);
        this.comms.close();
        this.log.fine(className, z[1], z[0]);
    }

    public void destory() {
        k.b();
        if (this.comms != null) {
            this.comms.destroy();
        }
    }

    public Debug getDebug() {
        return new Debug(this.clientId, this.comms);
    }

    public static void validateTopic(String string) {
        if (string.indexOf(35) == -1 && string.indexOf(43) == -1) {
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public MqttToken ping(IMqttActionListener object) {
        MqttToken mqttToken = new MqttToken(this.getClientId());
        mqttToken.setActionCallback((IMqttActionListener)object);
        object = new MqttPingReq();
        this.comms.sendNoWait((MqttWireMessage)object, mqttToken);
        return mqttToken;
    }

    public MqttToken expand(b b2) {
        MqttToken mqttToken = new MqttToken(this.getClientId());
        switch (b2.g) {
            case 7: {
                Object object = null;
                if (b2.f != null) {
                    object = new JSONObject(b2.f.toString());
                }
                object = new MqttExpandPublish(b2.c, b2.d, b2.g, (JSONObject)object);
                mqttToken.setUserContext(b2.b);
                this.comms.sendNoWait((MqttWireMessage)object, mqttToken);
                break;
            }
            default: {
                MqttExpand mqttExpand = new MqttExpand(b2.c, b2.g);
                mqttToken.setUserContext(b2.b);
                this.comms.sendNoWait(mqttExpand, mqttToken);
            }
        }
        return mqttToken;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[30];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "9\u00053";
        int n3 = -1;
        block37: while (true) {
            char[] cArray;
            block42: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block41: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block41;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block42;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 8;
                                break;
                            }
                            case 1: {
                                n9 = 52;
                                break;
                            }
                            case 2: {
                                n9 = 7;
                                break;
                            }
                            case 3: {
                                n9 = 73;
                                break;
                            }
                            default: {
                                n9 = 46;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "kXh:K";
                    n3 = 0;
                    continue block37;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "9\u00054";
                    n3 = 1;
                    continue block37;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "9\u00040";
                    n3 = 2;
                    continue block37;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "9\u00057";
                    n3 = 3;
                    continue block37;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "}Zt<L{Wu Lm";
                    n3 = 4;
                    continue block37;
                }
                case 4: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 6;
                    string2 = "$\u0014";
                    n3 = 5;
                    continue block37;
                }
                case 5: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 7;
                    string2 = "SZh=@}Xk\u0014";
                    n3 = 6;
                    continue block37;
                }
                case 6: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 8;
                    string2 = "9\u00044";
                    n3 = 7;
                    continue block37;
                }
                case 7: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 9;
                    string2 = "SZr%BU";
                    n3 = 8;
                    continue block37;
                }
                case 8: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 10;
                    string2 = "k[i'Kk@";
                    n3 = 9;
                    continue block37;
                }
                case 9: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 11;
                    string2 = "9\u00056";
                    n3 = 10;
                    continue block37;
                }
                case 10: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 12;
                    string2 = "9\u00055";
                    n3 = 11;
                    continue block37;
                }
                case 11: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 13;
                    string2 = "xAe%G{\\";
                    n3 = 12;
                    continue block37;
                }
                case 12: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 14;
                    string2 = "9\u0004?";
                    n3 = 13;
                    continue block37;
                }
                case 13: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 15;
                    string2 = "l]t*AfZb*Z";
                    n3 = 14;
                    continue block37;
                }
                case 14: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 16;
                    string2 = "9\u00043";
                    n3 = 15;
                    continue block37;
                }
                case 15: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 17;
                    string2 = "9\u00042";
                    n3 = 16;
                    continue block37;
                }
                case 16: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 18;
                    string2 = "}Gb;\u0000fUj,";
                    n3 = 17;
                    continue block37;
                }
                case 17: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 19;
                    string2 = "{Gks\u0001'";
                    n3 = 18;
                    continue block37;
                }
                case 18: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 20;
                    string2 = "|Wws\u0001'";
                    n3 = 19;
                    continue block37;
                }
                case 19: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 21;
                    string2 = "d[d(B2\u001b(";
                    n3 = 20;
                    continue block37;
                }
                case 20: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 22;
                    string2 = "9\u0004>";
                    n3 = 21;
                    continue block37;
                }
                case 21: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 23;
                    string2 = "9\u00041";
                    n3 = 22;
                    continue block37;
                }
                case 22: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 24;
                    string2 = "{Ae:Mz]e,";
                    n3 = 23;
                    continue block37;
                }
                case 23: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 25;
                    string2 = "9\u00052";
                    n3 = 24;
                    continue block37;
                }
                case 24: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 26;
                    string2 = "kFb(Zmzb=YgFl\u0004AlAk,";
                    n3 = 25;
                    continue block37;
                }
                case 25: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 27;
                    string2 = "gF`gKkXn9]m\u001aw(Fg\u001ad%GmZsgCy@s?\u001d&]i=KzZf%\u0000fXtgBgSd(Z";
                    n3 = 26;
                    continue block37;
                }
                case 26: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 28;
                    string2 = "9\u00046";
                    n3 = 27;
                    continue block37;
                }
                case 27: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 29;
                    string2 = "EEs=o{Mi*md]b'Z";
                    n3 = 28;
                    continue block37;
                }
                case 28: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        z = stringArray3;
        className = MqttAsyncClient.class.getName();
    }
}

